/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.TableBuildingUtils;
import tech.tablesaw.io.html.HtmlReadOptions;

public class HtmlReader
implements DataReader<HtmlReadOptions> {
    private static final HtmlReader INSTANCE = new HtmlReader();

    public static void register(ReaderRegistry registry) {
        registry.registerExtension("html", (DataReader)INSTANCE);
        registry.registerMimeType("text/html", (DataReader)INSTANCE);
        registry.registerOptions(HtmlReadOptions.class, (DataReader)INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table read(HtmlReadOptions options) {
        Document doc;
        InputStream inputStream = options.source().inputStream();
        try {
            doc = inputStream != null ? Jsoup.parse((InputStream)inputStream, null, (String)"") : Parser.htmlParser().parseInput(options.source().createReader(null), "");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        Elements tables = doc.select("table");
        int tableIndex = 0;
        if (tables.size() != 1) {
            if (options.tableIndex() == null) throw new IllegalStateException(tables.size() + " tables found. When more than one html table is present on the page you must specify the index of the table to read from.");
            if (options.tableIndex() < 0 || options.tableIndex() >= tables.size()) throw new IndexOutOfBoundsException("Table index outside bounds. The URL has " + tables.size() + " tables");
            tableIndex = options.tableIndex();
        }
        Element htmlTable = (Element)tables.get(tableIndex);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (Element row : htmlTable.select("tr")) {
            Elements headerCells = row.getElementsByTag("th");
            Elements cells = row.getElementsByTag("td");
            String[] nextLine = (String[])Stream.concat(headerCells.stream(), cells.stream()).map(Element::text).toArray(String[]::new);
            rows.add(nextLine);
        }
        Table table = Table.create((String)options.tableName());
        if (rows.isEmpty()) {
            return table;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        if (options.header()) {
            String[] headerRow = (String[])rows.remove(0);
            for (int i = 0; i < headerRow.length; ++i) {
                columnNames.add(headerRow[i]);
            }
            return TableBuildingUtils.build(columnNames, rows, (ReadOptions)options);
        } else {
            for (int i = 0; i < ((String[])rows.get(0)).length; ++i) {
                columnNames.add("C" + i);
            }
        }
        return TableBuildingUtils.build(columnNames, rows, (ReadOptions)options);
    }

    public Table read(Source source) {
        return this.read(HtmlReadOptions.builder(source).build());
    }

    static {
        HtmlReader.register(Table.defaultReaderRegistry);
    }
}

