/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.entities.medium;

import java.util.List;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.RegexTransform;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectHtml;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;

@RegexSupportsParser(pattern="\\.?medium\\.com\\/")
public class Page
implements ImportedEntity {
    private SourceInfo sourceInfo;
    @EntityPart(selectContext=".section-content")
    private UserShortInfo author;
    @SelectText(value=".section-content h1:nth-child(1)")
    private String name;
    @SelectHtml(value=".section-content", transform=SelectHtml.Transform.MARKDOWN)
    private String contentHtml;
    @SelectAttribute(selector=".u-flexCenter.js-collectionLogoOrName img", attr="alt")
    private String category;
    @SelectText(value=".section-content")
    private String contentText;
    @SelectText(value="[data-action=show-recommends]")
    private String clapsCount;
    @SelectText(value=".tags a", multi=true)
    private List<String> tags;

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public UserShortInfo getAuthor() {
        return this.author;
    }

    public String getName() {
        return this.name;
    }

    public String getContentHtml() {
        return this.contentHtml;
    }

    public String getCategory() {
        return this.category;
    }

    public String getContentText() {
        return this.contentText;
    }

    public String getClapsCount() {
        return this.clapsCount;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setAuthor(UserShortInfo author) {
        this.author = author;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContentHtml(String contentHtml) {
        this.contentHtml = contentHtml;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setContentText(String contentText) {
        this.contentText = contentText;
    }

    public void setClapsCount(String clapsCount) {
        this.clapsCount = clapsCount;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SourceInfo this$sourceInfo = this.getSourceInfo();
        SourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !this$sourceInfo.equals(other$sourceInfo)) {
            return false;
        }
        UserShortInfo this$author = this.getAuthor();
        UserShortInfo other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$contentHtml = this.getContentHtml();
        String other$contentHtml = other.getContentHtml();
        if (this$contentHtml == null ? other$contentHtml != null : !this$contentHtml.equals(other$contentHtml)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$contentText = this.getContentText();
        String other$contentText = other.getContentText();
        if (this$contentText == null ? other$contentText != null : !this$contentText.equals(other$contentText)) {
            return false;
        }
        String this$clapsCount = this.getClapsCount();
        String other$clapsCount = other.getClapsCount();
        if (this$clapsCount == null ? other$clapsCount != null : !this$clapsCount.equals(other$clapsCount)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : $sourceInfo.hashCode());
        UserShortInfo $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $contentHtml = this.getContentHtml();
        result = result * 59 + ($contentHtml == null ? 43 : $contentHtml.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $contentText = this.getContentText();
        result = result * 59 + ($contentText == null ? 43 : $contentText.hashCode());
        String $clapsCount = this.getClapsCount();
        result = result * 59 + ($clapsCount == null ? 43 : $clapsCount.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "Page(sourceInfo=" + this.getSourceInfo() + ", author=" + this.getAuthor() + ", name=" + this.getName() + ", contentHtml=" + this.getContentHtml() + ", category=" + this.getCategory() + ", contentText=" + this.getContentText() + ", clapsCount=" + this.getClapsCount() + ", tags=" + this.getTags() + ")";
    }

    public static class UserShortInfo {
        @SelectAttribute(selector="[data-user-id]", attr="href")
        @RegexTransform(pattern="@[_a-zA-Z1-9]+", group=0)
        private String id;
        @SelectText(value="[data-user-id]")
        private String name;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserShortInfo)) {
                return false;
            }
            UserShortInfo other = (UserShortInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserShortInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Page.UserShortInfo(id=" + this.getId() + ", name=" + this.getName() + ")";
        }
    }
}

