/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.entities.medium;

import java.util.List;
import javax.validation.constraints.NotBlank;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.RegexTransform;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.UrlExtract;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;

@RegexSupportsParser(pattern="\\.?medium\\.com\\/@")
public class Author
implements ImportedEntity {
    private SourceInfo sourceInfo;
    @UrlExtract(pattern="\\.?medium\\.com\\/(@[^?]+)", group=1)
    private String id;
    @SelectText(value=".hero-title")
    @NotBlank
    private String name;
    @SelectText(value=".hero-description")
    private String about;
    @SelectAttribute(selector="[aria-label=Twitter]", attr="href")
    private String twitter;
    @SelectText(value="[data-action-value=following]")
    @RegexTransform(pattern="^[\\d.K]+")
    private String followingCount;
    @SelectText(value="[data-action-value=followers]")
    @RegexTransform(pattern="^[\\d.K]+")
    private long followerCount;
    @EntityPart(selectContext="div.streamItem", target=PageInfo.class)
    private List<PageInfo> stories;

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAbout() {
        return this.about;
    }

    public String getTwitter() {
        return this.twitter;
    }

    public String getFollowingCount() {
        return this.followingCount;
    }

    public long getFollowerCount() {
        return this.followerCount;
    }

    public List<PageInfo> getStories() {
        return this.stories;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAbout(String about) {
        this.about = about;
    }

    public void setTwitter(String twitter) {
        this.twitter = twitter;
    }

    public void setFollowingCount(String followingCount) {
        this.followingCount = followingCount;
    }

    public void setFollowerCount(long followerCount) {
        this.followerCount = followerCount;
    }

    public void setStories(List<PageInfo> stories) {
        this.stories = stories;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Author)) {
            return false;
        }
        Author other = (Author)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SourceInfo this$sourceInfo = this.getSourceInfo();
        SourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !this$sourceInfo.equals(other$sourceInfo)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$about = this.getAbout();
        String other$about = other.getAbout();
        if (this$about == null ? other$about != null : !this$about.equals(other$about)) {
            return false;
        }
        String this$twitter = this.getTwitter();
        String other$twitter = other.getTwitter();
        if (this$twitter == null ? other$twitter != null : !this$twitter.equals(other$twitter)) {
            return false;
        }
        String this$followingCount = this.getFollowingCount();
        String other$followingCount = other.getFollowingCount();
        if (this$followingCount == null ? other$followingCount != null : !this$followingCount.equals(other$followingCount)) {
            return false;
        }
        if (this.getFollowerCount() != other.getFollowerCount()) {
            return false;
        }
        List<PageInfo> this$stories = this.getStories();
        List<PageInfo> other$stories = other.getStories();
        return !(this$stories == null ? other$stories != null : !((Object)this$stories).equals(other$stories));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Author;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : $sourceInfo.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $about = this.getAbout();
        result = result * 59 + ($about == null ? 43 : $about.hashCode());
        String $twitter = this.getTwitter();
        result = result * 59 + ($twitter == null ? 43 : $twitter.hashCode());
        String $followingCount = this.getFollowingCount();
        result = result * 59 + ($followingCount == null ? 43 : $followingCount.hashCode());
        long $followerCount = this.getFollowerCount();
        result = result * 59 + (int)($followerCount >>> 32 ^ $followerCount);
        List<PageInfo> $stories = this.getStories();
        result = result * 59 + ($stories == null ? 43 : ((Object)$stories).hashCode());
        return result;
    }

    public String toString() {
        return "Author(sourceInfo=" + this.getSourceInfo() + ", id=" + this.getId() + ", name=" + this.getName() + ", about=" + this.getAbout() + ", twitter=" + this.getTwitter() + ", followingCount=" + this.getFollowingCount() + ", followerCount=" + this.getFollowerCount() + ", stories=" + this.getStories() + ")";
    }

    public static class PageInfo {
        @SelectText(value="h3")
        private String name;
        @SelectText(value="h4")
        private String shortDescription;
        @SelectText(value="[data-action=show-recommends]")
        private long clapsCount;

        public String getName() {
            return this.name;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public long getClapsCount() {
            return this.clapsCount;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        public void setClapsCount(long clapsCount) {
            this.clapsCount = clapsCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PageInfo)) {
                return false;
            }
            PageInfo other = (PageInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$shortDescription = this.getShortDescription();
            String other$shortDescription = other.getShortDescription();
            if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
                return false;
            }
            return this.getClapsCount() == other.getClapsCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof PageInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $shortDescription = this.getShortDescription();
            result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
            long $clapsCount = this.getClapsCount();
            result = result * 59 + (int)($clapsCount >>> 32 ^ $clapsCount);
            return result;
        }

        public String toString() {
            return "Author.PageInfo(name=" + this.getName() + ", shortDescription=" + this.getShortDescription() + ", clapsCount=" + this.getClapsCount() + ")";
        }
    }
}

