/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.entities.imdb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.MapSelector;
import net.tislib.websiteparser.annotations.ParseDateTime;
import net.tislib.websiteparser.annotations.ParserEntity;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectContext;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.SplitText;
import net.tislib.websiteparser.annotations.UrlExtract;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;

@ParserEntity
@RegexSupportsParser(pattern="(^https?://(?!pro\\.)(?!m\\.)[\\w\\W]*)imdb\\.com/name/(nm\\d+)($|\\/$|\\?|\\/\\?)")
public class Name
implements ImportedEntity {
    private SourceInfo sourceInfo;
    @UrlExtract(pattern="[^m]\\.imdb\\.com/name/(nm\\d+)($|\\/$|\\?|\\/\\?)", group=1)
    private String id;
    @SelectText(value="#overview-top h1.header > span")
    @NotBlank
    private String name;
    @SelectText(value="#maindetails_center_bottom > div.article.highlighted > span")
    private String awardsShort;
    @SelectText(value="#name-job-categories")
    @SplitText(pattern="\\|", subType=String.class)
    private Set<String> work;
    @EntityPart
    private BiographyInfo bio;
    @EntityPart(selectContext="#filmography > div")
    @MapSelector(keySelector=@SelectText(value="$.head"), valueSelector=@SelectContext(selector="$:not(.head) > div", target=FilmograpyItem.class))
    private Map<String, FilmograpyItem> movies;
    @EntityPart(selectContext="#knownfor > div", target=KnowForFilmograpyItem.class)
    private List<KnowForFilmograpyItem> knownMovies;

    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAwardsShort() {
        return this.awardsShort;
    }

    public Set<String> getWork() {
        return this.work;
    }

    public BiographyInfo getBio() {
        return this.bio;
    }

    public Map<String, FilmograpyItem> getMovies() {
        return this.movies;
    }

    public List<KnowForFilmograpyItem> getKnownMovies() {
        return this.knownMovies;
    }

    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAwardsShort(String awardsShort) {
        this.awardsShort = awardsShort;
    }

    public void setWork(Set<String> work) {
        this.work = work;
    }

    public void setBio(BiographyInfo bio) {
        this.bio = bio;
    }

    public void setMovies(Map<String, FilmograpyItem> movies) {
        this.movies = movies;
    }

    public void setKnownMovies(List<KnowForFilmograpyItem> knownMovies) {
        this.knownMovies = knownMovies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Name)) {
            return false;
        }
        Name other = (Name)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SourceInfo this$sourceInfo = this.getSourceInfo();
        SourceInfo other$sourceInfo = other.getSourceInfo();
        if (this$sourceInfo == null ? other$sourceInfo != null : !this$sourceInfo.equals(other$sourceInfo)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$awardsShort = this.getAwardsShort();
        String other$awardsShort = other.getAwardsShort();
        if (this$awardsShort == null ? other$awardsShort != null : !this$awardsShort.equals(other$awardsShort)) {
            return false;
        }
        Set<String> this$work = this.getWork();
        Set<String> other$work = other.getWork();
        if (this$work == null ? other$work != null : !((Object)this$work).equals(other$work)) {
            return false;
        }
        BiographyInfo this$bio = this.getBio();
        BiographyInfo other$bio = other.getBio();
        if (this$bio == null ? other$bio != null : !((Object)this$bio).equals(other$bio)) {
            return false;
        }
        Map<String, FilmograpyItem> this$movies = this.getMovies();
        Map<String, FilmograpyItem> other$movies = other.getMovies();
        if (this$movies == null ? other$movies != null : !((Object)this$movies).equals(other$movies)) {
            return false;
        }
        List<KnowForFilmograpyItem> this$knownMovies = this.getKnownMovies();
        List<KnowForFilmograpyItem> other$knownMovies = other.getKnownMovies();
        return !(this$knownMovies == null ? other$knownMovies != null : !((Object)this$knownMovies).equals(other$knownMovies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Name;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SourceInfo $sourceInfo = this.getSourceInfo();
        result = result * 59 + ($sourceInfo == null ? 43 : $sourceInfo.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $awardsShort = this.getAwardsShort();
        result = result * 59 + ($awardsShort == null ? 43 : $awardsShort.hashCode());
        Set<String> $work = this.getWork();
        result = result * 59 + ($work == null ? 43 : ((Object)$work).hashCode());
        BiographyInfo $bio = this.getBio();
        result = result * 59 + ($bio == null ? 43 : ((Object)$bio).hashCode());
        Map<String, FilmograpyItem> $movies = this.getMovies();
        result = result * 59 + ($movies == null ? 43 : ((Object)$movies).hashCode());
        List<KnowForFilmograpyItem> $knownMovies = this.getKnownMovies();
        result = result * 59 + ($knownMovies == null ? 43 : ((Object)$knownMovies).hashCode());
        return result;
    }

    public String toString() {
        return "Name(sourceInfo=" + this.getSourceInfo() + ", id=" + this.getId() + ", name=" + this.getName() + ", awardsShort=" + this.getAwardsShort() + ", work=" + this.getWork() + ", bio=" + this.getBio() + ", movies=" + this.getMovies() + ", knownMovies=" + this.getKnownMovies() + ")";
    }

    @ParserEntity
    public static class BiographyInfo {
        @SelectText(value="#name-bio-text > div > div")
        private String about;
        @ParseDateTime(value="YYYY-MM-DD")
        private String bornDate;

        public String getAbout() {
            return this.about;
        }

        public String getBornDate() {
            return this.bornDate;
        }

        public void setAbout(String about) {
            this.about = about;
        }

        public void setBornDate(String bornDate) {
            this.bornDate = bornDate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BiographyInfo)) {
                return false;
            }
            BiographyInfo other = (BiographyInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$about = this.getAbout();
            String other$about = other.getAbout();
            if (this$about == null ? other$about != null : !this$about.equals(other$about)) {
                return false;
            }
            String this$bornDate = this.getBornDate();
            String other$bornDate = other.getBornDate();
            return !(this$bornDate == null ? other$bornDate != null : !this$bornDate.equals(other$bornDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BiographyInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $about = this.getAbout();
            result = result * 59 + ($about == null ? 43 : $about.hashCode());
            String $bornDate = this.getBornDate();
            result = result * 59 + ($bornDate == null ? 43 : $bornDate.hashCode());
            return result;
        }

        public String toString() {
            return "Name.BiographyInfo(about=" + this.getAbout() + ", bornDate=" + this.getBornDate() + ")";
        }
    }

    @ParserEntity
    public static class KnowForFilmograpyItem
    extends FilmograpyItem {
        @SelectAttribute(selector="div.knownfor-title-role > a", attr="href")
        private String movieId;
        @SelectText(value="div.knownfor-title-role > a")
        private String movieName;
        @SelectText(value="div.knownfor-title-role > span")
        private String characterName;
        @SelectText(value="div.knownfor-year > span")
        private String date;

        @Override
        public String getMovieId() {
            return this.movieId;
        }

        @Override
        public String getMovieName() {
            return this.movieName;
        }

        @Override
        public String getCharacterName() {
            return this.characterName;
        }

        @Override
        public String getDate() {
            return this.date;
        }

        @Override
        public void setMovieId(String movieId) {
            this.movieId = movieId;
        }

        @Override
        public void setMovieName(String movieName) {
            this.movieName = movieName;
        }

        @Override
        public void setCharacterName(String characterName) {
            this.characterName = characterName;
        }

        @Override
        public void setDate(String date) {
            this.date = date;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KnowForFilmograpyItem)) {
                return false;
            }
            KnowForFilmograpyItem other = (KnowForFilmograpyItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$movieId = this.getMovieId();
            String other$movieId = other.getMovieId();
            if (this$movieId == null ? other$movieId != null : !this$movieId.equals(other$movieId)) {
                return false;
            }
            String this$movieName = this.getMovieName();
            String other$movieName = other.getMovieName();
            if (this$movieName == null ? other$movieName != null : !this$movieName.equals(other$movieName)) {
                return false;
            }
            String this$characterName = this.getCharacterName();
            String other$characterName = other.getCharacterName();
            if (this$characterName == null ? other$characterName != null : !this$characterName.equals(other$characterName)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof KnowForFilmograpyItem;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $movieId = this.getMovieId();
            result = result * 59 + ($movieId == null ? 43 : $movieId.hashCode());
            String $movieName = this.getMovieName();
            result = result * 59 + ($movieName == null ? 43 : $movieName.hashCode());
            String $characterName = this.getCharacterName();
            result = result * 59 + ($characterName == null ? 43 : $characterName.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "Name.KnowForFilmograpyItem(movieId=" + this.getMovieId() + ", movieName=" + this.getMovieName() + ", characterName=" + this.getCharacterName() + ", date=" + this.getDate() + ")";
        }
    }

    @ParserEntity
    public static class FilmograpyItem {
        @SelectText(value=" > b > a")
        private String movieId;
        @SelectText(value=" > b > a")
        private String movieName;
        @SelectText(value=" > a")
        private String status;
        @SelectText(value=" > a")
        private String characterName;
        @SelectText(value=" > span.year_column")
        private String date;

        public String getMovieId() {
            return this.movieId;
        }

        public String getMovieName() {
            return this.movieName;
        }

        public String getStatus() {
            return this.status;
        }

        public String getCharacterName() {
            return this.characterName;
        }

        public String getDate() {
            return this.date;
        }

        public void setMovieId(String movieId) {
            this.movieId = movieId;
        }

        public void setMovieName(String movieName) {
            this.movieName = movieName;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setCharacterName(String characterName) {
            this.characterName = characterName;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilmograpyItem)) {
                return false;
            }
            FilmograpyItem other = (FilmograpyItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$movieId = this.getMovieId();
            String other$movieId = other.getMovieId();
            if (this$movieId == null ? other$movieId != null : !this$movieId.equals(other$movieId)) {
                return false;
            }
            String this$movieName = this.getMovieName();
            String other$movieName = other.getMovieName();
            if (this$movieName == null ? other$movieName != null : !this$movieName.equals(other$movieName)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$characterName = this.getCharacterName();
            String other$characterName = other.getCharacterName();
            if (this$characterName == null ? other$characterName != null : !this$characterName.equals(other$characterName)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FilmograpyItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $movieId = this.getMovieId();
            result = result * 59 + ($movieId == null ? 43 : $movieId.hashCode());
            String $movieName = this.getMovieName();
            result = result * 59 + ($movieName == null ? 43 : $movieName.hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $characterName = this.getCharacterName();
            result = result * 59 + ($characterName == null ? 43 : $characterName.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        public String toString() {
            return "Name.FilmograpyItem(movieId=" + this.getMovieId() + ", movieName=" + this.getMovieName() + ", status=" + this.getStatus() + ", characterName=" + this.getCharacterName() + ", date=" + this.getDate() + ")";
        }
    }
}

