/*
 * Decompiled with CFR 0.152.
 */
package net.tislib.websiteparser.entities.gsmarena;

import java.util.List;
import java.util.Map;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectText;

@RegexSupportsParser(pattern="^https?://www\\\\.gsmarena\\\\.com/?[\\\\w\\\\W]+\"")
public class Device {
    @SelectText(value=".specs-phone-name-title")
    public String name;
    @SelectText(value="[data-spec=released-hl]")
    public String releaseStatus;
    @SelectText(value="#specs-list > div > div > h2")
    public List<String> versions;
    @EntityPart(selectContext="[data-spec]", target=DataSpec.class)
    private Map<String, String> properties;

    public String getName() {
        return this.name;
    }

    public String getReleaseStatus() {
        return this.releaseStatus;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReleaseStatus(String releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    public void setVersions(List<String> versions) {
        this.versions = versions;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device other = (Device)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$releaseStatus = this.getReleaseStatus();
        String other$releaseStatus = other.getReleaseStatus();
        if (this$releaseStatus == null ? other$releaseStatus != null : !this$releaseStatus.equals(other$releaseStatus)) {
            return false;
        }
        List<String> this$versions = this.getVersions();
        List<String> other$versions = other.getVersions();
        if (this$versions == null ? other$versions != null : !((Object)this$versions).equals(other$versions)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Device;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $releaseStatus = this.getReleaseStatus();
        result = result * 59 + ($releaseStatus == null ? 43 : $releaseStatus.hashCode());
        List<String> $versions = this.getVersions();
        result = result * 59 + ($versions == null ? 43 : ((Object)$versions).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "Device(name=" + this.getName() + ", releaseStatus=" + this.getReleaseStatus() + ", versions=" + this.getVersions() + ", properties=" + this.getProperties() + ")";
    }

    public static class DataSpec
    implements Map.Entry<String, String> {
        @SelectAttribute(attr="data-spec")
        private String key;
        @SelectText
        private String value;

        @Override
        public String setValue(String value) {
            this.value = value;
            return this.value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataSpec)) {
                return false;
            }
            DataSpec other = (DataSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataSpec;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Device.DataSpec(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }
}

