package net.tislib.websiteparser.entities.medium;

import static net.tislib.websiteparser.annotations.SelectHtml.Transform.MARKDOWN;

import java.util.List;
import lombok.Data;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.RegexTransform;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectHtml;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;

@Data
@RegexSupportsParser(pattern = "\\.?medium\\.com\\/")
public class Page implements ImportedEntity {
    private SourceInfo sourceInfo;

    @EntityPart(selectContext = ".section-content")
    private UserShortInfo author;

    @SelectText(".section-content h1:nth-child(1)")
    private String name;

    @SelectHtml(value = ".section-content", transform = MARKDOWN)
    private String contentHtml;

    @SelectAttribute(selector = ".u-flexCenter.js-collectionLogoOrName img", attr = "alt")
    private String category;

    @SelectText(".section-content")
    private String contentText;

    @SelectText("[data-action=show-recommends]")
    private String clapsCount;

    @SelectText(value = ".tags a", multi = true)
    private List<String> tags;

    @Data
    public static class UserShortInfo {
        @SelectAttribute(selector = "[data-user-id]", attr = "href")
        @RegexTransform(pattern = "@[_a-zA-Z1-9]+", group = 0)
        private String id;

        @SelectText("[data-user-id]")
        private String name;
    }
}
