package net.tislib.websiteparser.entities.medium;

import static net.tislib.websiteparser.annotations.RegexTransform.NUMBER_PARSE_PATTERN;

import java.util.List;
import javax.validation.constraints.NotBlank;
import lombok.Data;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.RegexTransform;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.UrlExtract;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;

@Data
@RegexSupportsParser(pattern = "\\.?medium\\.com\\/@")
public class Author implements ImportedEntity {
    private SourceInfo sourceInfo;

    @UrlExtract(pattern = "\\.?medium\\.com\\/(@[^?]+)", group = 1)
    private String id;

    @SelectText(".hero-title")
    @NotBlank
    private String name;

    @SelectText(".hero-description")
    private String about;

    @SelectAttribute(selector = "[aria-label=Twitter]", attr = "href")
    private String twitter;

    @SelectText("[data-action-value=following]")
    @RegexTransform(pattern = "^" + NUMBER_PARSE_PATTERN)
    private String followingCount;

    @SelectText("[data-action-value=followers]")
    @RegexTransform(pattern = "^" + NUMBER_PARSE_PATTERN)
    private long followerCount;

    @EntityPart(selectContext = "div.streamItem", target = PageInfo.class)
    private List<PageInfo> stories;

    @Data
    public static class PageInfo {
        @SelectText("h3")
        private String name;

        @SelectText("h4")
        private String shortDescription;

        @SelectText("[data-action=show-recommends]")
        private long clapsCount;
    }
}
