package net.tislib.websiteparser.entities.imdb;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import lombok.Data;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.MapSelector;
import net.tislib.websiteparser.annotations.ParseDateTime;
import net.tislib.websiteparser.annotations.ParserEntity;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectContext;
import net.tislib.websiteparser.annotations.SelectText;
import net.tislib.websiteparser.annotations.SplitText;
import net.tislib.websiteparser.annotations.UrlExtract;
import net.tislib.websiteparser.annotations.generic.ImportedEntity;
import net.tislib.websiteparser.annotations.generic.SourceInfo;

@Data
@ParserEntity
@RegexSupportsParser(pattern = "(^https?://(?!pro\\.)(?!m\\.)[\\w\\W]*)imdb\\.com/name/(nm\\d+)($|\\/$|\\?|\\/\\?)")
public class Name implements ImportedEntity {
    private SourceInfo sourceInfo;

    @UrlExtract(pattern = "[^m]\\.imdb\\.com/name/(nm\\d+)($|\\/$|\\?|\\/\\?)", group = 1)
    private String id;

    @SelectText("#overview-top h1.header > span")
    @NotBlank
    private String name;

    @SelectText("#maindetails_center_bottom > div.article.highlighted > span")
    private String awardsShort;

    @SelectText("#name-job-categories")
    @SplitText(pattern = "\\|", subType = String.class)
    private Set<String> work;

    @EntityPart
    private BiographyInfo bio;

    @EntityPart(selectContext = "#filmography > div")
    @MapSelector(keySelector = @SelectText("$.head"),
            valueSelector = @SelectContext(selector = "$:not(.head) > div", target = FilmograpyItem.class)
    )
    private Map<String, FilmograpyItem> movies;

    @EntityPart(selectContext = "#knownfor > div", target = KnowForFilmograpyItem.class)
    private List<KnowForFilmograpyItem> knownMovies;

    @Data
    @ParserEntity
    public static class FilmograpyItem {
        @SelectText(" > b > a")
        private String movieId;

        @SelectText(" > b > a")
        private String movieName;

        @SelectText(" > a")
        private String status;

        @SelectText(" > a")
        private String characterName;

        @SelectText(" > span.year_column")
        private String date;
    }

    @Data
    @ParserEntity
    public static class KnowForFilmograpyItem extends FilmograpyItem {
        @SelectAttribute(selector = "div.knownfor-title-role > a", attr = "href")
        private String movieId; // fix to long

        @SelectText("div.knownfor-title-role > a")
        private String movieName;

        @SelectText("div.knownfor-title-role > span")
        private String characterName;

        @SelectText("div.knownfor-year > span")
        private String date;
    }

    @Data
    @ParserEntity
    public static class BiographyInfo {
        @SelectText("#name-bio-text > div > div")
        private String about;

//        @SelectAttribute(selector = "#name-born-info > time", attr = "datetime")
        @ParseDateTime("YYYY-MM-DD")
        private String bornDate;
    }
}
