package net.tislib.websiteparser.entities.gsmarena;

import java.util.List;
import java.util.Map;
import lombok.Data;
import net.tislib.websiteparser.annotations.EntityPart;
import net.tislib.websiteparser.annotations.RegexSupportsParser;
import net.tislib.websiteparser.annotations.SelectAttribute;
import net.tislib.websiteparser.annotations.SelectText;

@Data
@RegexSupportsParser(pattern = "^https?://www\\\\.gsmarena\\\\.com/?[\\\\w\\\\W]+\"")
public class Device {

    @SelectText(".specs-phone-name-title")
    public String name;

    @SelectText("[data-spec=released-hl]")
    public String releaseStatus;

    @SelectText("#specs-list > div > div > h2")
    public List<String> versions;

    @EntityPart(selectContext = "[data-spec]", target = DataSpec.class)
    private Map<String, String> properties;

    @Data
    public static class DataSpec implements Map.Entry<String, String> {
        @SelectAttribute(attr = "data-spec")
        private String key;

        @SelectText
        private String value;

        @Override
        public String setValue(String value) {
            return this.value = value;
        }
    }

}
