/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.writer;

import net.thisptr.jmx.exporter.agent.misc.StringWriter;

public class SanitizingStringWriter
implements StringWriter {
    private static final SanitizingStringWriter INSTANCE = new SanitizingStringWriter();

    public static SanitizingStringWriter getInstance() {
        return INSTANCE;
    }

    @Override
    public int expectedSize(String name) {
        return name.length() + 1;
    }

    @Override
    public int write(String name, byte[] bytes, int index) {
        int savedIndex = index;
        int length = name.length();
        if (length == 0) {
            bytes[index++] = 95;
            return index;
        }
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if ('a' <= ch && ch <= 'z' || ch == '_' || ch == ':' || 'A' <= ch && ch <= 'Z') {
                bytes[index++] = (byte)ch;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                if (index == savedIndex) {
                    bytes[index++] = 95;
                }
                bytes[index++] = (byte)ch;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++i;
            }
            bytes[index++] = 95;
        }
        return index;
    }
}

