/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.SslClientAuthMode;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseStreamConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseXnioSsl;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.SslConnection;

public final class JsseSslConnection
extends SslConnection {
    private final StreamConnection streamConnection;
    private final JsseStreamConduit conduit;
    private final ChannelListener.SimpleSetter<SslConnection> handshakeSetter = new ChannelListener.SimpleSetter();
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add((Option<?>)Options.SECURE, (Option<?>)Options.SSL_CLIENT_AUTH_MODE).create();

    public JsseSslConnection(StreamConnection streamConnection, SSLEngine engine) {
        this(streamConnection, engine, JsseXnioSsl.bufferPool, JsseXnioSsl.bufferPool);
    }

    JsseSslConnection(StreamConnection streamConnection, SSLEngine engine, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool) {
        super(streamConnection.getIoThread());
        this.streamConnection = streamConnection;
        this.conduit = new JsseStreamConduit(this, engine, streamConnection.getSourceChannel().getConduit(), streamConnection.getSinkChannel().getConduit(), socketBufferPool, applicationBufferPool);
        this.setSourceConduit(this.conduit);
        this.setSinkConduit(this.conduit);
    }

    @Override
    public void startHandshake() throws IOException {
        this.conduit.beginHandshake();
    }

    @Override
    public SSLSession getSslSession() {
        return this.conduit.getSslSession();
    }

    @Override
    protected void closeAction() throws IOException {
        try {
            if (!this.conduit.isWriteShutdown()) {
                this.conduit.terminateWrites();
            }
            if (!this.conduit.isReadShutdown()) {
                this.conduit.terminateReads();
            }
            this.conduit.flush();
            this.conduit.markTerminated();
            this.streamConnection.close();
        }
        catch (Throwable t) {
            try {
                if (!this.conduit.isReadShutdown()) {
                    this.conduit.terminateReads();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.conduit.markTerminated();
                this.streamConnection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
    }

    @Override
    protected void notifyWriteClosed() {
    }

    @Override
    protected void notifyReadClosed() {
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.streamConnection.getPeerAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.streamConnection.getLocalAddress();
    }

    @Override
    public ChannelListener.Setter<? extends SslConnection> getHandshakeSetter() {
        return this.handshakeSetter;
    }

    void invokeHandshakeListener() {
        ChannelListeners.invokeChannelListener(this, this.handshakeSetter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            T t;
            SSLEngine engine = this.conduit.getEngine();
            try {
                t = option.cast((Object)(engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
                engine.setNeedClientAuth(value == SslClientAuthMode.REQUIRED);
                engine.setWantClientAuth(value == SslClientAuthMode.REQUESTED);
            }
            catch (Throwable throwable) {
                engine.setNeedClientAuth(value == SslClientAuthMode.REQUIRED);
                engine.setWantClientAuth(value == SslClientAuthMode.REQUESTED);
                throw throwable;
            }
            return t;
        }
        if (option == Options.SECURE) {
            throw new IllegalArgumentException();
        }
        return this.streamConnection.setOption(option, value);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            SSLEngine engine = this.conduit.getEngine();
            return option.cast((Object)(engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
        }
        return option == Options.SECURE ? option.cast(this.conduit.isTls()) : this.streamConnection.getOption(option);
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.streamConnection.supportsOption(option);
    }

    @Override
    public boolean isOpen() {
        return this.streamConnection.isOpen();
    }

    @Override
    public boolean isWriteShutdown() {
        return this.streamConnection.isWriteShutdown();
    }

    @Override
    public boolean isReadShutdown() {
        return this.streamConnection.isReadShutdown();
    }

    public SSLEngine getEngine() {
        return this.conduit.getEngine();
    }
}

