/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.AcceptingChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.AbstractAcceptingSslChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseSslConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseSslStreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.JsseXnioSsl;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.SslConnection;

final class JsseAcceptingSslStreamConnection
extends AbstractAcceptingSslChannel<SslConnection, StreamConnection> {
    JsseAcceptingSslStreamConnection(SSLContext sslContext, AcceptingChannel<? extends StreamConnection> tcpServer, OptionMap optionMap, Pool<ByteBuffer> socketBufferPool, Pool<ByteBuffer> applicationBufferPool, boolean startTls) {
        super(sslContext, tcpServer, optionMap, socketBufferPool, applicationBufferPool, startTls);
    }

    @Override
    public SslConnection accept(StreamConnection tcpConnection, SSLEngine engine) throws IOException {
        if (!JsseXnioSsl.NEW_IMPL) {
            return new JsseSslStreamConnection(tcpConnection, engine, this.socketBufferPool, this.applicationBufferPool, this.startTls);
        }
        JsseSslConnection connection = new JsseSslConnection(tcpConnection, engine, this.socketBufferPool, this.applicationBufferPool);
        if (!this.startTls) {
            try {
                connection.startHandshake();
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)connection);
                throw e;
            }
        }
        return connection;
    }
}

