/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits;

import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.CloseListenerSettable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.SuspendableWriteChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.WriteListenerSettable;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.TerminateHandler;

public interface WriteReadyHandler
extends TerminateHandler {
    public void writeReady();

    public static class ReadyTask
    implements Runnable {
        private final WriteReadyHandler handler;

        public ReadyTask(WriteReadyHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.writeReady();
        }
    }

    public static class ChannelListenerHandler<C extends SuspendableWriteChannel & WriteListenerSettable<C>>
    implements WriteReadyHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void writeReady() {
            ChannelListener writeListener = ((WriteListenerSettable)this.channel).getWriteListener();
            if (writeListener == null) {
                this.channel.suspendWrites();
            } else {
                ChannelListeners.invokeChannelListener(this.channel, writeListener);
            }
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

