/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.xnio.channels;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListeners;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Option;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio._private.Messages;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.CloseableChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.SuspendableReadChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.SuspendableWriteChannel;

public class AssembledChannel
implements CloseableChannel {
    private final SuspendableReadChannel readChannel;
    private final SuspendableWriteChannel writeChannel;
    private final ChannelListener.SimpleSetter<AssembledChannel> closeSetter = new ChannelListener.SimpleSetter();
    private final ChannelListener<CloseableChannel> listener = new ChannelListener<CloseableChannel>(){

        @Override
        public void handleEvent(CloseableChannel channel) {
            int newState;
            int oldState;
            AssembledChannel obj = AssembledChannel.this;
            do {
                if ((oldState = stateUpdater.get(obj)) == 3) {
                    return;
                }
                newState = oldState;
                if (channel == AssembledChannel.this.readChannel) {
                    newState |= 1;
                }
                if (channel != AssembledChannel.this.writeChannel) continue;
                newState |= 2;
            } while (!stateUpdater.compareAndSet(obj, oldState, newState));
            if (newState == 3) {
                ChannelListeners.invokeChannelListener(obj, AssembledChannel.this.closeSetter.get());
            }
        }
    };
    private volatile int state = 0;
    private static final AtomicIntegerFieldUpdater<AssembledChannel> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(AssembledChannel.class, "state");

    public AssembledChannel(SuspendableReadChannel readChannel, SuspendableWriteChannel writeChannel) {
        this.readChannel = readChannel;
        this.writeChannel = writeChannel;
        if (readChannel.getWorker() != writeChannel.getWorker()) {
            throw Messages.msg.differentWorkers();
        }
    }

    @Override
    public ChannelListener.Setter<? extends CloseableChannel> getCloseSetter() {
        this.readChannel.getCloseSetter().set(this.listener);
        this.writeChannel.getCloseSetter().set(this.listener);
        return this.closeSetter;
    }

    @Override
    public XnioWorker getWorker() {
        return this.readChannel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.readChannel.getIoThread();
    }

    @Override
    public void close() throws IOException {
        try {
            this.readChannel.close();
            this.writeChannel.close();
        }
        finally {
            IoUtils.safeClose((Closeable)this.readChannel);
            IoUtils.safeClose((Closeable)this.writeChannel);
        }
    }

    @Override
    public boolean isOpen() {
        return this.readChannel.isOpen() && this.writeChannel.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.readChannel.supportsOption(option) || this.writeChannel.supportsOption(option);
    }

    private static <T> T nonNullOrFirst(T one, T two) {
        return one != null ? one : two;
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return AssembledChannel.nonNullOrFirst(this.readChannel.getOption(option), this.writeChannel.getOption(option));
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return AssembledChannel.nonNullOrFirst(this.readChannel.setOption(option, value), this.writeChannel.setOption(option, value));
    }
}

