/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.net;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.net.HostName;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.net.Inet;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

final class Substitutions {
    Substitutions() {
    }

    static final class ProcessSubstitutions {
        static final int SIZE = 512;

        ProcessSubstitutions() {
        }
    }

    static final class NativeInfoDirectives
    implements CContext.Directives {
        NativeInfoDirectives() {
        }

        public List<String> getHeaderFiles() {
            return Collections.singletonList("<unistd.h>");
        }
    }

    @CContext(value=NativeInfoDirectives.class)
    static final class NativeInfo {
        NativeInfo() {
        }

        @CFunction
        static native int gethostname(CCharPointer var0, UnsignedWord var1);
    }

    @TargetClass(className="net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.net.GetHostInfoAction")
    static final class Target_org_wildfly_common_net_GetHostInfoAction {
        Target_org_wildfly_common_net_GetHostInfoAction() {
        }

        @Substitute
        public String[] run() {
            String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
            String providedHostName = System.getProperty("jboss.host.name");
            String providedNodeName = System.getProperty("jboss.node.name");
            if (qualifiedHostName == null) {
                CCharPointer nameBuf;
                int res;
                qualifiedHostName = providedHostName;
                if (qualifiedHostName == null && (res = NativeInfo.gethostname(nameBuf = (CCharPointer)StackValue.get((int)512), WordFactory.unsigned((int)512))) != -1 && res > 0) {
                    if (res == 512) {
                        nameBuf.write(511, (byte)0);
                    }
                    qualifiedHostName = CTypeConversion.toJavaString((CCharPointer)nameBuf);
                }
                if (qualifiedHostName == null) {
                    qualifiedHostName = System.getenv("HOSTNAME");
                }
                if (qualifiedHostName == null) {
                    qualifiedHostName = System.getenv("COMPUTERNAME");
                }
                if (qualifiedHostName == null) {
                    try {
                        qualifiedHostName = HostName.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        qualifiedHostName = null;
                    }
                }
                if (qualifiedHostName != null && (Inet.isInet4Address(qualifiedHostName) || Inet.isInet6Address(qualifiedHostName))) {
                    qualifiedHostName = null;
                }
                qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
            }
            if (providedHostName == null) {
                int idx = qualifiedHostName.indexOf(46);
                String string = providedHostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
            }
            if (providedNodeName == null) {
                providedNodeName = providedHostName;
            }
            return new String[]{providedHostName, qualifiedHostName, providedNodeName};
        }
    }
}

