/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration;

import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common._private.CommonMessages;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.codec.Base64Alphabet;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.Base64DecodingByteIterator;
import net.thisptr.jmx.exporter.agent.shade.org.wildfly.common.iteration.CodePointIterator;

final class LittleEndianBase64DecodingByteIterator
extends Base64DecodingByteIterator {
    private final Base64Alphabet alphabet;

    LittleEndianBase64DecodingByteIterator(CodePointIterator iter, boolean requirePadding, Base64Alphabet alphabet) {
        super(iter, requirePadding);
        this.alphabet = alphabet;
    }

    @Override
    int calc0(int b0, int b1) {
        int d0 = this.alphabet.decode(b0);
        int d1 = this.alphabet.decode(b1);
        if (d0 == -1 || d1 == -1) {
            throw CommonMessages.msg.invalidBase64Character();
        }
        return (d0 | d1 << 6) & 0xFF;
    }

    @Override
    int calc1(int b1, int b2) {
        int d1 = this.alphabet.decode(b1);
        int d2 = this.alphabet.decode(b2);
        if (d1 == -1 || d2 == -1) {
            throw CommonMessages.msg.invalidBase64Character();
        }
        return (d1 >> 2 | d2 << 4) & 0xFF;
    }

    @Override
    int calc2(int b2, int b3) {
        int d2 = this.alphabet.decode(b2);
        int d3 = this.alphabet.decode(b3);
        if (d2 == -1 || d3 == -1) {
            throw CommonMessages.msg.invalidBase64Character();
        }
        return (d2 >> 4 | d3 << 2) & 0xFF;
    }
}

