/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.wildfly.client.config;

import java.io.IOException;
import java.io.Reader;

final class CountingReader
extends Reader {
    private int lineNumber = 1;
    private int columnNumber = 1;
    private int characterOffset = 0;
    private final Reader reader;

    CountingReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read() throws IOException {
        int ch = this.reader.read();
        if (ch == -1) {
            return -1;
        }
        this.processChar(ch);
        return ch;
    }

    private void processChar(int ch) {
        switch (ch) {
            case 10: {
                ++this.characterOffset;
                ++this.lineNumber;
                this.columnNumber = 1;
                break;
            }
            default: {
                if (Character.isLowSurrogate((char)ch)) break;
                ++this.characterOffset;
                ++this.columnNumber;
            }
        }
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int cnt = this.reader.read(cbuf);
        if (cnt > 0) {
            for (int i = 0; i < cnt; ++i) {
                this.processChar(cbuf[i]);
            }
        }
        return cnt;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int cnt = this.reader.read(cbuf, off, len);
        if (cnt > 0) {
            for (int i = 0; i < cnt; ++i) {
                this.processChar(cbuf[i + off]);
            }
        }
        return cnt;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getCharacterOffset() {
        return this.characterOffset;
    }
}

