/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.jboss.threads;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.threads.JBossExecutors;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.threads.JBossThread;
import net.thisptr.jmx.exporter.agent.shade.org.jboss.threads.ThreadNameInfo;

public final class JBossThreadFactory
implements ThreadFactory {
    private final ThreadGroup threadGroup;
    private final Boolean daemon;
    private final Integer initialPriority;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Long stackSize;
    private final String namePattern;
    private final AtomicLong factoryThreadIndexSequence = new AtomicLong(1L);
    private final long factoryIndex;
    private final AccessControlContext creatingContext;
    private static final AtomicLong globalThreadIndexSequence = new AtomicLong(1L);
    private static final AtomicLong factoryIndexSequence = new AtomicLong(1L);

    public JBossThreadFactory(ThreadGroup threadGroup, Boolean daemon, Integer initialPriority, String namePattern, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Long stackSize) {
        if (threadGroup == null) {
            SecurityManager sm = System.getSecurityManager();
            threadGroup = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }
        this.threadGroup = threadGroup;
        this.daemon = daemon;
        this.initialPriority = initialPriority;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.stackSize = stackSize;
        this.factoryIndex = factoryIndexSequence.getAndIncrement();
        if (namePattern == null) {
            namePattern = "pool-%f-thread-%t";
        }
        this.namePattern = namePattern;
        this.creatingContext = AccessController.getContext();
    }

    public JBossThreadFactory(ThreadGroup threadGroup, Boolean daemon, Integer initialPriority, String namePattern, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Long stackSize, AccessControlContext ignored) {
        this(threadGroup, daemon, initialPriority, namePattern, uncaughtExceptionHandler, stackSize);
    }

    @Override
    public Thread newThread(Runnable target) {
        AccessControlContext context = this.creatingContext;
        if (context != null) {
            return AccessController.doPrivileged(new ThreadCreateAction(target), context);
        }
        return this.createThread(target);
    }

    private Thread createThread(Runnable target) {
        ThreadNameInfo nameInfo = new ThreadNameInfo(globalThreadIndexSequence.getAndIncrement(), this.factoryThreadIndexSequence.getAndIncrement(), this.factoryIndex);
        JBossThread thread = this.stackSize != null ? new JBossThread(this.threadGroup, target, "<new>", this.stackSize) : new JBossThread(this.threadGroup, target);
        thread.setThreadNameInfo(nameInfo);
        thread.setName(nameInfo.format(thread, this.namePattern));
        if (this.initialPriority != null) {
            thread.setPriority(this.initialPriority);
        }
        if (this.daemon != null) {
            thread.setDaemon(this.daemon);
        }
        if (this.uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        JBossExecutors.clearContextClassLoader(thread);
        return thread;
    }

    private final class ThreadCreateAction
    implements PrivilegedAction<Thread> {
        private final Runnable target;

        private ThreadCreateAction(Runnable target) {
            this.target = target;
        }

        @Override
        public Thread run() {
            return JBossThreadFactory.this.createThread(this.target);
        }
    }
}

