/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ClockProvider;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidatorFactory;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.MessageInterpolator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ParameterNameProvider;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.TraversableResolver;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.Validator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.valueextraction.ValueExtractor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.HibernateValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ConstraintCreationContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ValidatorFactoryImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ValidatorFactoryScopedContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorDescriptor;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidatorContextImpl
implements HibernateValidatorContext {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final ValidatorFactoryImpl validatorFactory;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private final ValidatorFactoryScopedContext.Builder validatorFactoryScopedContextBuilder;
    private final ConstraintCreationContext constraintCreationContext;
    private final MethodValidationConfiguration.Builder methodValidationConfigurationBuilder;
    private final Map<ValueExtractorDescriptor.Key, ValueExtractorDescriptor> valueExtractorDescriptors;

    public ValidatorContextImpl(ValidatorFactoryImpl validatorFactory) {
        this.validatorFactoryScopedContextBuilder = new ValidatorFactoryScopedContext.Builder(validatorFactory.getValidatorFactoryScopedContext());
        this.validatorFactory = validatorFactory;
        this.constraintValidatorFactory = validatorFactory.getConstraintValidatorFactory();
        this.constraintCreationContext = validatorFactory.getConstraintCreationContext();
        this.methodValidationConfigurationBuilder = new MethodValidationConfiguration.Builder(validatorFactory.getMethodValidationConfiguration());
        this.valueExtractorDescriptors = new HashMap<ValueExtractorDescriptor.Key, ValueExtractorDescriptor>();
    }

    @Override
    public HibernateValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.validatorFactoryScopedContextBuilder.setMessageInterpolator(messageInterpolator);
        return this;
    }

    @Override
    public HibernateValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.validatorFactoryScopedContextBuilder.setTraversableResolver(traversableResolver);
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorFactory(ConstraintValidatorFactory factory) {
        this.constraintValidatorFactory = factory == null ? this.validatorFactory.getConstraintValidatorFactory() : factory;
        return this;
    }

    @Override
    public HibernateValidatorContext parameterNameProvider(ParameterNameProvider parameterNameProvider) {
        this.validatorFactoryScopedContextBuilder.setParameterNameProvider(parameterNameProvider);
        return this;
    }

    @Override
    public HibernateValidatorContext clockProvider(ClockProvider clockProvider) {
        this.validatorFactoryScopedContextBuilder.setClockProvider(clockProvider);
        return this;
    }

    @Override
    public HibernateValidatorContext addValueExtractor(ValueExtractor<?> extractor) {
        ValueExtractorDescriptor descriptor = new ValueExtractorDescriptor(extractor);
        ValueExtractorDescriptor previous = this.valueExtractorDescriptors.put(descriptor.getKey(), descriptor);
        if (previous != null) {
            throw LOG.getValueExtractorForTypeAndTypeUseAlreadyPresentException(extractor, previous.getValueExtractor());
        }
        return this;
    }

    @Override
    public HibernateValidatorContext failFast(boolean failFast) {
        this.validatorFactoryScopedContextBuilder.setFailFast(failFast);
        return this;
    }

    @Override
    public HibernateValidatorContext allowOverridingMethodAlterParameterConstraint(boolean allow) {
        this.methodValidationConfigurationBuilder.allowOverridingMethodAlterParameterConstraint(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext allowMultipleCascadedValidationOnReturnValues(boolean allow) {
        this.methodValidationConfigurationBuilder.allowMultipleCascadedValidationOnReturnValues(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext allowParallelMethodsDefineParameterConstraints(boolean allow) {
        this.methodValidationConfigurationBuilder.allowParallelMethodsDefineParameterConstraints(allow);
        return this;
    }

    @Override
    public HibernateValidatorContext enableTraversableResolverResultCache(boolean enabled) {
        this.validatorFactoryScopedContextBuilder.setTraversableResolverResultCacheEnabled(enabled);
        return this;
    }

    @Override
    public HibernateValidatorContext temporalValidationTolerance(Duration temporalValidationTolerance) {
        this.validatorFactoryScopedContextBuilder.setTemporalValidationTolerance(temporalValidationTolerance);
        return this;
    }

    @Override
    public HibernateValidatorContext constraintValidatorPayload(Object dynamicPayload) {
        this.validatorFactoryScopedContextBuilder.setConstraintValidatorPayload(dynamicPayload);
        return this;
    }

    @Override
    public Validator getValidator() {
        return this.validatorFactory.createValidator(this.constraintValidatorFactory, this.valueExtractorDescriptors.isEmpty() ? this.constraintCreationContext : new ConstraintCreationContext(this.constraintCreationContext.getConstraintHelper(), this.constraintCreationContext.getConstraintValidatorManager(), this.constraintCreationContext.getTypeResolutionHelper(), new ValueExtractorManager(this.constraintCreationContext.getValueExtractorManager(), this.valueExtractorDescriptors)), this.validatorFactoryScopedContextBuilder.build(), this.methodValidationConfigurationBuilder.build());
    }
}

