/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ClockProvider;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidatorFactory;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.MessageInterpolator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ParameterNameProvider;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.TraversableResolver;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.Validator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.spi.ConfigurationState;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.HibernateValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.HibernateValidatorFactory;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.PredefinedScopeHibernateValidatorFactory;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.cfg.context.DefaultConstraintMapping;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ConstraintCreationContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.MethodValidationConfiguration;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.PredefinedScopeConfigurationImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.PredefinedScopeValidatorContextImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ValidatorFactoryConfigurationHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ValidatorFactoryScopedContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.ValidatorImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.constraintvalidation.ConstraintValidatorManager;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.constraintvalidation.PredefinedScopeConstraintValidatorManagerImpl;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.groups.ValidationOrderGenerator;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.valueextraction.ValueExtractorManager;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.PredefinedScopeBeanMetaDataManager;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.provider.ProgrammaticMetaDataProvider;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.metadata.provider.XmlMetaDataProvider;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.properties.javabean.JavaBeanHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.CollectionHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.Contracts;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.ExecutableHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.ExecutableParameterNameProvider;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.TypeResolutionHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

public class PredefinedScopeValidatorFactoryImpl
implements PredefinedScopeHibernateValidatorFactory {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private final ValidatorFactoryScopedContext validatorFactoryScopedContext;
    private final ConstraintValidatorManager constraintValidatorManager;
    private final MethodValidationConfiguration methodValidationConfiguration;
    private final PredefinedScopeBeanMetaDataManager beanMetaDataManager;
    private final ValueExtractorManager valueExtractorManager;
    private final GetterPropertySelectionStrategy getterPropertySelectionStrategy;
    private final ValidationOrderGenerator validationOrderGenerator;

    public PredefinedScopeValidatorFactoryImpl(ConfigurationState configurationState) {
        Contracts.assertTrue(configurationState instanceof PredefinedScopeConfigurationImpl, "Only PredefinedScopeConfigurationImpl is supported.");
        ClassLoader externalClassLoader = ValidatorFactoryConfigurationHelper.determineExternalClassLoader(configurationState);
        PredefinedScopeConfigurationImpl hibernateSpecificConfig = (PredefinedScopeConfigurationImpl)configurationState;
        Map<String, String> properties = configurationState.getProperties();
        this.methodValidationConfiguration = new MethodValidationConfiguration.Builder().allowOverridingMethodAlterParameterConstraint(ValidatorFactoryConfigurationHelper.determineAllowOverridingMethodAlterParameterConstraint(hibernateSpecificConfig, properties)).allowMultipleCascadedValidationOnReturnValues(ValidatorFactoryConfigurationHelper.determineAllowMultipleCascadedValidationOnReturnValues(hibernateSpecificConfig, properties)).allowParallelMethodsDefineParameterConstraints(ValidatorFactoryConfigurationHelper.determineAllowParallelMethodsDefineParameterConstraints(hibernateSpecificConfig, properties)).build();
        this.validatorFactoryScopedContext = new ValidatorFactoryScopedContext(configurationState.getMessageInterpolator(), configurationState.getTraversableResolver(), new ExecutableParameterNameProvider(configurationState.getParameterNameProvider()), configurationState.getClockProvider(), ValidatorFactoryConfigurationHelper.determineTemporalValidationTolerance(configurationState, properties), ValidatorFactoryConfigurationHelper.determineScriptEvaluatorFactory(configurationState, properties, externalClassLoader), ValidatorFactoryConfigurationHelper.determineFailFast(hibernateSpecificConfig, properties), ValidatorFactoryConfigurationHelper.determineTraversableResolverResultCacheEnabled(hibernateSpecificConfig, properties), ValidatorFactoryConfigurationHelper.determineConstraintValidatorPayload(hibernateSpecificConfig));
        this.constraintValidatorManager = new PredefinedScopeConstraintValidatorManagerImpl(configurationState.getConstraintValidatorFactory(), this.validatorFactoryScopedContext.getConstraintValidatorInitializationContext());
        this.validationOrderGenerator = new ValidationOrderGenerator();
        this.getterPropertySelectionStrategy = ValidatorFactoryConfigurationHelper.determineGetterPropertySelectionStrategy(hibernateSpecificConfig, properties, externalClassLoader);
        this.valueExtractorManager = new ValueExtractorManager(configurationState.getValueExtractors());
        ConstraintHelper constraintHelper = ConstraintHelper.forBuiltinConstraints(hibernateSpecificConfig.getBuiltinConstraints());
        TypeResolutionHelper typeResolutionHelper = new TypeResolutionHelper();
        ConstraintCreationContext constraintCreationContext = new ConstraintCreationContext(constraintHelper, this.constraintValidatorManager, typeResolutionHelper, this.valueExtractorManager);
        ExecutableHelper executableHelper = new ExecutableHelper(typeResolutionHelper);
        JavaBeanHelper javaBeanHelper = new JavaBeanHelper(ValidatorFactoryConfigurationHelper.determineGetterPropertySelectionStrategy(hibernateSpecificConfig, properties, externalClassLoader), ValidatorFactoryConfigurationHelper.determinePropertyNodeNameProvider(hibernateSpecificConfig, properties, externalClassLoader));
        XmlMetaDataProvider xmlMetaDataProvider = configurationState.getMappingStreams().isEmpty() ? null : new XmlMetaDataProvider(constraintCreationContext, javaBeanHelper, configurationState.getMappingStreams(), externalClassLoader);
        Set<DefaultConstraintMapping> constraintMappings = Collections.unmodifiableSet(ValidatorFactoryConfigurationHelper.determineConstraintMappings(typeResolutionHelper, configurationState, javaBeanHelper, externalClassLoader));
        ValidatorFactoryConfigurationHelper.registerCustomConstraintValidators(constraintMappings, constraintHelper);
        this.beanMetaDataManager = new PredefinedScopeBeanMetaDataManager(constraintCreationContext, executableHelper, this.validatorFactoryScopedContext.getParameterNameProvider(), javaBeanHelper, this.validationOrderGenerator, PredefinedScopeValidatorFactoryImpl.buildMetaDataProviders(constraintCreationContext, xmlMetaDataProvider, constraintMappings), this.methodValidationConfiguration, ValidatorFactoryConfigurationHelper.determineBeanMetaDataClassNormalizer(hibernateSpecificConfig), hibernateSpecificConfig.getBeanClassesToInitialize());
        if (LOG.isDebugEnabled()) {
            ValidatorFactoryConfigurationHelper.logValidatorFactoryScopedConfiguration(this.validatorFactoryScopedContext);
        }
    }

    @Override
    public Validator getValidator() {
        return this.createValidator(this.validatorFactoryScopedContext);
    }

    @Override
    public MessageInterpolator getMessageInterpolator() {
        return this.validatorFactoryScopedContext.getMessageInterpolator();
    }

    @Override
    public TraversableResolver getTraversableResolver() {
        return this.validatorFactoryScopedContext.getTraversableResolver();
    }

    @Override
    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorManager.getDefaultConstraintValidatorFactory();
    }

    @Override
    public ParameterNameProvider getParameterNameProvider() {
        return this.validatorFactoryScopedContext.getParameterNameProvider().getDelegate();
    }

    public ExecutableParameterNameProvider getExecutableParameterNameProvider() {
        return this.validatorFactoryScopedContext.getParameterNameProvider();
    }

    @Override
    public ClockProvider getClockProvider() {
        return this.validatorFactoryScopedContext.getClockProvider();
    }

    @Override
    public ScriptEvaluatorFactory getScriptEvaluatorFactory() {
        return this.validatorFactoryScopedContext.getScriptEvaluatorFactory();
    }

    @Override
    public Duration getTemporalValidationTolerance() {
        return this.validatorFactoryScopedContext.getTemporalValidationTolerance();
    }

    @Override
    public GetterPropertySelectionStrategy getGetterPropertySelectionStrategy() {
        return this.getterPropertySelectionStrategy;
    }

    public boolean isFailFast() {
        return this.validatorFactoryScopedContext.isFailFast();
    }

    public boolean isTraversableResolverResultCacheEnabled() {
        return this.validatorFactoryScopedContext.isTraversableResolverResultCacheEnabled();
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(PredefinedScopeHibernateValidatorFactory.class) || type.isAssignableFrom(HibernateValidatorFactory.class)) {
            return type.cast(this);
        }
        throw LOG.getTypeNotSupportedForUnwrappingException(type);
    }

    @Override
    public HibernateValidatorContext usingContext() {
        return new PredefinedScopeValidatorContextImpl(this);
    }

    @Override
    public void close() {
        this.constraintValidatorManager.clear();
        this.beanMetaDataManager.clear();
        this.validatorFactoryScopedContext.getScriptEvaluatorFactory().clear();
        this.valueExtractorManager.clear();
    }

    public ValidatorFactoryScopedContext getValidatorFactoryScopedContext() {
        return this.validatorFactoryScopedContext;
    }

    Validator createValidator(ValidatorFactoryScopedContext validatorFactoryScopedContext) {
        return new ValidatorImpl(this.constraintValidatorManager.getDefaultConstraintValidatorFactory(), this.beanMetaDataManager, this.valueExtractorManager, this.constraintValidatorManager, this.validationOrderGenerator, validatorFactoryScopedContext);
    }

    private static List<MetaDataProvider> buildMetaDataProviders(ConstraintCreationContext constraintCreationContext, XmlMetaDataProvider xmlMetaDataProvider, Set<DefaultConstraintMapping> constraintMappings) {
        ArrayList<MetaDataProvider> metaDataProviders = CollectionHelper.newArrayList();
        if (xmlMetaDataProvider != null) {
            metaDataProviders.add(xmlMetaDataProvider);
        }
        if (!constraintMappings.isEmpty()) {
            metaDataProviders.add(new ProgrammaticMetaDataProvider(constraintCreationContext, constraintMappings));
        }
        return metaDataProviders;
    }
}

