/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.constraintvalidators.hv;

import java.net.MalformedURLException;
import java.net.URL;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidatorContext;

public class URLValidator
implements ConstraintValidator<net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.URL, CharSequence> {
    private String protocol;
    private String host;
    private int port;

    @Override
    public void initialize(net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraints.URL url) {
        this.protocol = url.protocol();
        this.host = url.host();
        this.port = url.port();
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        URL url;
        if (value == null || value.length() == 0) {
            return true;
        }
        try {
            url = new URL(value.toString());
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (this.protocol != null && this.protocol.length() > 0 && !url.getProtocol().equals(this.protocol)) {
            return false;
        }
        if (this.host != null && this.host.length() > 0 && !url.getHost().equals(this.host)) {
            return false;
        }
        return this.port == -1 || url.getPort() == this.port;
    }
}

