/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.constraintvalidators.bv;

import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidator;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.ConstraintValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.javax.validation.constraints.Pattern;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.engine.messageinterpolation.util.InterpolationHelper;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.Log;
import net.thisptr.jmx.exporter.agent.shade.org.hibernate.validator.internal.util.logging.LoggerFactory;

public class PatternValidator
implements ConstraintValidator<Pattern, CharSequence> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private java.util.regex.Pattern pattern;
    private String escapedRegexp;

    @Override
    public void initialize(Pattern parameters) {
        Pattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = java.util.regex.Pattern.compile(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw LOG.getInvalidRegularExpressionException(e);
        }
        this.escapedRegexp = InterpolationHelper.escapeMessageParameter(parameters.regexp());
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
            constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class).addMessageParameter("regexp", this.escapedRegexp);
        }
        Matcher m3 = this.pattern.matcher(value);
        return m3.matches();
    }
}

