/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.protocol.version13;

import java.io.Closeable;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketChannel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.WebSocketVersion;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.protocol.version13.WebSocket13Channel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.extensions.CompositeExtensionFunction;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.extensions.ExtensionFunction;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.spi.WebSocketHttpExchange;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;

public class Hybi13Handshake
extends Hybi07Handshake {
    public Hybi13Handshake() {
        super(WebSocketVersion.V13, Collections.emptySet(), false);
    }

    public Hybi13Handshake(Set<String> subprotocols, boolean allowExtensions) {
        super(WebSocketVersion.V13, subprotocols, allowExtensions);
    }

    @Override
    protected void handshakeInternal(WebSocketHttpExchange exchange) {
        String origin = exchange.getRequestHeader("Origin");
        if (origin != null) {
            exchange.setResponseHeader("Origin", origin);
        }
        this.selectSubprotocol(exchange);
        this.selectExtensions(exchange);
        exchange.setResponseHeader("Sec-WebSocket-Location", Hybi13Handshake.getWebSocketLocation(exchange));
        String key = exchange.getRequestHeader("Sec-WebSocket-Key");
        try {
            String solution = this.solve(key);
            exchange.setResponseHeader("Sec-WebSocket-Accept", solution);
            this.performUpgrade(exchange);
        }
        catch (NoSuchAlgorithmException e) {
            IoUtils.safeClose((Closeable)exchange);
            exchange.endExchange();
            return;
        }
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, StreamConnection channel, ByteBufferPool pool) {
        List<ExtensionFunction> extensionFunctions = this.initExtensions(exchange);
        return new WebSocket13Channel(channel, pool, Hybi13Handshake.getWebSocketLocation(exchange), exchange.getResponseHeader("Sec-WebSocket-Protocol"), false, !extensionFunctions.isEmpty(), CompositeExtensionFunction.compose(extensionFunctions), exchange.getPeerConnections(), exchange.getOptions());
    }
}

