/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.core.StreamSinkFrameChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.Channels;

public final class BinaryOutputStream
extends OutputStream {
    private final StreamSinkFrameChannel sender;
    private boolean closed;

    public BinaryOutputStream(StreamSinkFrameChannel sender) {
        this.sender = sender;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (Thread.currentThread() == this.sender.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Channels.writeBlocking(this.sender, ByteBuffer.wrap(b, off, len));
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        if (Thread.currentThread() == this.sender.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        Channels.writeBlocking(this.sender, ByteBuffer.wrap(new byte[]{(byte)b}));
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        if (Thread.currentThread() == this.sender.getIoThread()) {
            throw UndertowMessages.MESSAGES.awaitCalledFromIoThread();
        }
        this.sender.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.sender.shutdownWrites();
            Channels.flushBlocking(this.sender);
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.streamIsClosed();
        }
    }
}

