/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.util;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ObjectPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.PooledObject;

public class NewInstanceObjectPool<T>
implements ObjectPool {
    private final Supplier<T> supplier;
    private final Consumer<T> consumer;

    public NewInstanceObjectPool(Supplier<T> supplier, Consumer<T> consumer) {
        this.supplier = supplier;
        this.consumer = consumer;
    }

    public PooledObject allocate() {
        final T obj = this.supplier.get();
        return new PooledObject(){
            private volatile boolean closed = false;

            @Override
            public T getObject() {
                if (this.closed) {
                    throw UndertowMessages.MESSAGES.objectIsClosed();
                }
                return obj;
            }

            @Override
            public void close() {
                this.closed = true;
                NewInstanceObjectPool.this.consumer.accept(obj);
            }
        };
    }
}

