/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http2;

import java.io.IOException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Channel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.RenegotiationRequiredException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.SSLSessionInfo;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Options;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.SslClientAuthMode;

class Http2SslSessionInfo
implements SSLSessionInfo {
    private final Http2Channel channel;

    Http2SslSessionInfo(Http2Channel channel) {
        this.channel = channel;
    }

    @Override
    public byte[] getSessionId() {
        return this.channel.getSslSession().getId();
    }

    @Override
    public String getCipherSuite() {
        return this.channel.getSslSession().getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        try {
            return this.channel.getSslSession().getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            try {
                SslClientAuthMode sslClientAuthMode = this.channel.getOption(Options.SSL_CLIENT_AUTH_MODE);
                if (sslClientAuthMode == SslClientAuthMode.NOT_REQUESTED) {
                    throw new RenegotiationRequiredException();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    @Override
    public void renegotiate(HttpServerExchange exchange, SslClientAuthMode sslClientAuthMode) throws IOException {
        throw UndertowMessages.MESSAGES.renegotiationNotSupported();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.channel.getSslSession();
    }
}

