/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http2;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowLogger;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowOptions;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.BytesReceivedStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.BytesSentStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Channel;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatistics;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatisticsImpl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.DelegateOpenListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.XnioByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http2.Http2ReceiveListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Pool;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;

public final class Http2OpenListener
implements ChannelListener<StreamConnection>,
DelegateOpenListener {
    private final Set<Http2Channel> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    public static final String HTTP2 = "h2";
    @Deprecated
    public static final String HTTP2_14 = "h2-14";
    private final ByteBufferPool bufferPool;
    private final int bufferSize;
    private final ChannelListener<Http2Channel> closeTask = new ChannelListener<Http2Channel>(){

        @Override
        public void handleEvent(Http2Channel channel) {
            Http2OpenListener.this.connectorStatistics.decrementConnectionCount();
        }
    };
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;
    private final ConnectorStatisticsImpl connectorStatistics;
    private final String protocol;

    @Deprecated
    public Http2OpenListener(Pool<ByteBuffer> pool) {
        this(pool, OptionMap.EMPTY);
    }

    @Deprecated
    public Http2OpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this(pool, undertowOptions, HTTP2);
    }

    @Deprecated
    public Http2OpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, String protocol) {
        this(new XnioByteBufferPool(pool), undertowOptions, protocol);
    }

    public Http2OpenListener(ByteBufferPool pool) {
        this(pool, OptionMap.EMPTY);
    }

    public Http2OpenListener(ByteBufferPool pool, OptionMap undertowOptions) {
        this(pool, undertowOptions, HTTP2);
    }

    public Http2OpenListener(ByteBufferPool pool, OptionMap undertowOptions, String protocol) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        PooledByteBuffer buf = pool.allocate();
        this.bufferSize = buf.getBuffer().remaining();
        buf.close();
        this.connectorStatistics = new ConnectorStatisticsImpl();
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_STATISTICS, false);
        this.protocol = protocol;
    }

    @Override
    public void handleEvent(StreamConnection channel, PooledByteBuffer buffer) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened HTTP/2 connection with %s", (Object)channel.getPeerAddress());
        }
        Http2Channel http2Channel = new Http2Channel(channel, this.protocol, this.bufferPool, buffer, false, false, this.undertowOptions);
        Integer idleTimeout = this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
        if (idleTimeout != null && idleTimeout > 0) {
            http2Channel.setIdleTimeout(idleTimeout.intValue());
        }
        if (this.statisticsEnabled) {
            channel.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(channel.getSinkChannel().getConduit(), this.connectorStatistics.sentAccumulator()));
            channel.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(channel.getSourceChannel().getConduit(), this.connectorStatistics.receivedAccumulator()));
            this.connectorStatistics.incrementConnectionCount();
            http2Channel.addCloseTask(this.closeTask);
        }
        this.connections.add(http2Channel);
        http2Channel.addCloseTask(new ChannelListener<Http2Channel>(){

            @Override
            public void handleEvent(Http2Channel channel) {
                Http2OpenListener.this.connections.remove(channel);
            }
        });
        http2Channel.getReceiveSetter().set(new Http2ReceiveListener(this.rootHandler, this.getUndertowOptions(), this.bufferSize, this.connectorStatistics));
        http2Channel.resumeReceives();
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            return this.connectorStatistics;
        }
        return null;
    }

    @Override
    public void closeConnections() {
        for (Http2Channel i : this.connections) {
            IoUtils.safeClose((Closeable)i);
        }
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        this.handleEvent(channel, null);
    }
}

