/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http;

import java.io.Closeable;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSession;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ReadDataStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.PooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.AbstractServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConduitWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectionSSLSessionInfo;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConnectorStatisticsImpl;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.Connectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ExchangeCompletionListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpUpgradeListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.SSLSessionInfo;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ServerConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpContinue;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpReadListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpResponseConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpTransferEncoding;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.PipeliningBufferingStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.ServerFixedLengthStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ConduitFactory;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ImmediatePooledByteBuffer;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.SslChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;

public final class HttpServerConnection
extends AbstractServerConnection {
    private SSLSessionInfo sslSessionInfo;
    private HttpReadListener readListener;
    private PipeliningBufferingStreamSinkConduit pipelineBuffer;
    private HttpResponseConduit responseConduit;
    private ServerFixedLengthStreamSinkConduit fixedLengthStreamSinkConduit;
    private ReadDataStreamSourceConduit readDataStreamSourceConduit;
    private HttpUpgradeListener upgradeListener;
    private boolean connectHandled;

    public HttpServerConnection(StreamConnection channel, ByteBufferPool bufferPool, HttpHandler rootHandler, OptionMap undertowOptions, int bufferSize, final ConnectorStatisticsImpl connectorStatistics) {
        super(channel, bufferPool, rootHandler, undertowOptions, bufferSize);
        if (channel instanceof SslChannel) {
            this.sslSessionInfo = new ConnectionSSLSessionInfo((SslChannel)((Object)channel), this);
        }
        this.responseConduit = new HttpResponseConduit(channel.getSinkChannel().getConduit(), bufferPool, this);
        this.fixedLengthStreamSinkConduit = new ServerFixedLengthStreamSinkConduit(this.responseConduit, false, false);
        this.readDataStreamSourceConduit = new ReadDataStreamSourceConduit(channel.getSourceChannel().getConduit(), this);
        this.addCloseListener(new ServerConnection.CloseListener(){

            @Override
            public void closed(ServerConnection connection) {
                if (connectorStatistics != null) {
                    connectorStatistics.decrementConnectionCount();
                }
                HttpServerConnection.this.responseConduit.freeBuffers();
            }
        });
    }

    @Override
    public HttpServerExchange sendOutOfBandResponse(HttpServerExchange exchange) {
        if (exchange == null || !HttpContinue.requiresContinueResponse(exchange)) {
            throw UndertowMessages.MESSAGES.outOfBandResponseOnlyAllowedFor100Continue();
        }
        final AbstractServerConnection.ConduitState state = this.resetChannel();
        HttpServerExchange newExchange = new HttpServerExchange(this);
        for (HttpString header : exchange.getRequestHeaders().getHeaderNames()) {
            newExchange.getRequestHeaders().putAll(header, exchange.getRequestHeaders().get(header));
        }
        newExchange.setProtocol(exchange.getProtocol());
        newExchange.setRequestMethod(exchange.getRequestMethod());
        exchange.setRequestURI(exchange.getRequestURI(), exchange.isHostIncludedInRequestURI());
        exchange.setRequestPath(exchange.getRequestPath());
        exchange.setRelativePath(exchange.getRelativePath());
        newExchange.getRequestHeaders().put(Headers.CONNECTION, Headers.KEEP_ALIVE.toString());
        newExchange.getRequestHeaders().put(Headers.CONTENT_LENGTH, 0L);
        newExchange.setPersistent(true);
        Connectors.terminateRequest(newExchange);
        newExchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                final HttpResponseConduit httpResponseConduit = new HttpResponseConduit(HttpServerConnection.this.getSinkChannel().getConduit(), HttpServerConnection.this.getByteBufferPool(), HttpServerConnection.this, exchange);
                exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                    @Override
                    public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                        httpResponseConduit.freeContinueResponse();
                        nextListener.proceed();
                    }
                });
                ServerFixedLengthStreamSinkConduit fixed = new ServerFixedLengthStreamSinkConduit(httpResponseConduit, false, false);
                fixed.reset(0L, exchange);
                return fixed;
            }
        });
        this.channel.getSourceChannel().setConduit(HttpServerConnection.source(state));
        newExchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

            @Override
            public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                HttpServerConnection.this.restoreChannel(state);
            }
        });
        return newExchange;
    }

    @Override
    public boolean isContinueResponseSupported() {
        return true;
    }

    @Override
    public void terminateRequestChannel(HttpServerExchange exchange) {
        if (!exchange.isPersistent()) {
            IoUtils.safeClose((Closeable)this.getChannel().getSourceChannel());
        }
    }

    public void ungetRequestBytes(PooledByteBuffer unget) {
        if (this.getExtraBytes() == null) {
            this.setExtraBytes(unget);
        } else {
            PooledByteBuffer eb = this.getExtraBytes();
            ByteBuffer buf = eb.getBuffer();
            ByteBuffer ugBuffer = unget.getBuffer();
            if (ugBuffer.limit() - ugBuffer.remaining() > buf.remaining()) {
                ugBuffer.compact();
                ugBuffer.put(buf);
                ugBuffer.flip();
                eb.close();
                this.setExtraBytes(unget);
            } else {
                byte[] data = new byte[ugBuffer.remaining() + buf.remaining()];
                int first = ugBuffer.remaining();
                ugBuffer.get(data, 0, ugBuffer.remaining());
                buf.get(data, first, buf.remaining());
                eb.close();
                unget.close();
                ByteBuffer newBuffer = ByteBuffer.wrap(data);
                this.setExtraBytes(new ImmediatePooledByteBuffer(newBuffer));
            }
        }
    }

    @Override
    public SSLSessionInfo getSslSessionInfo() {
        return this.sslSessionInfo;
    }

    @Override
    public void setSslSessionInfo(SSLSessionInfo sessionInfo) {
        this.sslSessionInfo = sessionInfo;
    }

    @Override
    public SSLSession getSslSession() {
        if (this.channel instanceof SslChannel) {
            return ((SslChannel)((Object)this.channel)).getSslSession();
        }
        return null;
    }

    @Override
    protected StreamConnection upgradeChannel() {
        this.clearChannel();
        if (this.extraBytes != null) {
            this.channel.getSourceChannel().setConduit(new ReadDataStreamSourceConduit(this.channel.getSourceChannel().getConduit(), this));
        }
        return this.channel;
    }

    @Override
    protected StreamSinkConduit getSinkConduit(HttpServerExchange exchange, StreamSinkConduit conduit) {
        if (exchange.getRequestMethod().equals(Methods.CONNECT) && !this.connectHandled) {
            exchange.setPersistent(false);
            exchange.getResponseHeaders().put(Headers.CONNECTION, "close");
        }
        return HttpTransferEncoding.createSinkConduit(exchange);
    }

    @Override
    protected boolean isUpgradeSupported() {
        return true;
    }

    @Override
    protected boolean isConnectSupported() {
        return true;
    }

    void setReadListener(HttpReadListener readListener) {
        this.readListener = readListener;
    }

    @Override
    protected void exchangeComplete(HttpServerExchange exchange) {
        if (this.fixedLengthStreamSinkConduit != null) {
            this.fixedLengthStreamSinkConduit.clearExchange();
        }
        if (this.pipelineBuffer == null) {
            this.readListener.exchangeComplete(exchange);
        } else {
            this.pipelineBuffer.exchangeComplete(exchange);
        }
    }

    HttpReadListener getReadListener() {
        return this.readListener;
    }

    ReadDataStreamSourceConduit getReadDataStreamSourceConduit() {
        return this.readDataStreamSourceConduit;
    }

    public PipeliningBufferingStreamSinkConduit getPipelineBuffer() {
        return this.pipelineBuffer;
    }

    public HttpResponseConduit getResponseConduit() {
        return this.responseConduit;
    }

    ServerFixedLengthStreamSinkConduit getFixedLengthStreamSinkConduit() {
        return this.fixedLengthStreamSinkConduit;
    }

    protected HttpUpgradeListener getUpgradeListener() {
        return this.upgradeListener;
    }

    @Override
    protected void setUpgradeListener(HttpUpgradeListener upgradeListener) {
        this.upgradeListener = upgradeListener;
    }

    @Override
    protected void setConnectListener(HttpUpgradeListener connectListener) {
        this.upgradeListener = connectListener;
        this.connectHandled = true;
    }

    void setCurrentExchange(HttpServerExchange exchange) {
        this.current = exchange;
    }

    public void setPipelineBuffer(PipeliningBufferingStreamSinkConduit pipelineBuffer) {
        this.pipelineBuffer = pipelineBuffer;
        this.responseConduit = new HttpResponseConduit(pipelineBuffer, this.bufferPool, this);
        this.fixedLengthStreamSinkConduit = new ServerFixedLengthStreamSinkConduit(this.responseConduit, false, false);
    }

    @Override
    public String getTransportProtocol() {
        return "http/1.1";
    }

    @Override
    public boolean isRequestTrailerFieldsSupported() {
        if (this.current == null) {
            return false;
        }
        String te = this.current.getRequestHeaders().getFirst(Headers.TRANSFER_ENCODING);
        if (te == null) {
            return false;
        }
        return te.equalsIgnoreCase(Headers.CHUNKED.toString());
    }

    boolean isConnectHandled() {
        return this.connectHandled;
    }
}

