/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ExchangeCompletionListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster.ModClusterProxyTarget;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.mod_cluster.Node;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Bits;

class Context {
    private static final AtomicInteger idGen = new AtomicInteger();
    private final int id;
    private final Node node;
    private final String path;
    private final Node.VHostMapping vhost;
    private static final int STOPPED = Integer.MIN_VALUE;
    private static final int DISABLED = 0x40000000;
    private static final int REQUEST_MASK = 0x3FFFFFFF;
    private volatile int state = Integer.MIN_VALUE;
    private static final AtomicIntegerFieldUpdater<Context> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(Context.class, "state");

    Context(String path, Node.VHostMapping vHost, Node node) {
        this.id = idGen.incrementAndGet();
        this.path = path;
        this.node = node;
        this.vhost = vHost;
    }

    public int getId() {
        return this.id;
    }

    public String getJVMRoute() {
        return this.node.getJvmRoute();
    }

    public String getPath() {
        return this.path;
    }

    public List<String> getVirtualHosts() {
        return this.vhost.getAliases();
    }

    public int getActiveRequests() {
        return this.state & 0x3FFFFFFF;
    }

    public Status getStatus() {
        int state = this.state;
        if ((state & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            return Status.STOPPED;
        }
        if ((state & 0x40000000) == 0x40000000) {
            return Status.DISABLED;
        }
        return Status.ENABLED;
    }

    public boolean isEnabled() {
        return Bits.allAreClear(this.state, -1073741824);
    }

    public boolean isStopped() {
        return Bits.allAreSet(this.state, Integer.MIN_VALUE);
    }

    public boolean isDisabled() {
        return Bits.allAreSet(this.state, 0x40000000);
    }

    Node getNode() {
        return this.node;
    }

    Node.VHostMapping getVhost() {
        return this.vhost;
    }

    boolean checkAvailable(boolean existingSession) {
        if (this.node.checkAvailable(existingSession)) {
            return existingSession ? !this.isStopped() : this.isEnabled();
        }
        return false;
    }

    void enable() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState & 0x3FFFFFFF)) {
        }
    }

    void disable() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState | 0x40000000)) {
        }
    }

    void stop() {
        int newState;
        int oldState;
        while (!stateUpdater.compareAndSet(this, oldState = this.state, newState = oldState | Integer.MIN_VALUE)) {
        }
    }

    void handleRequest(ModClusterProxyTarget target, HttpServerExchange exchange, ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit, boolean exclusive) {
        if (this.addRequest()) {
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    Context.this.requestDone();
                    nextListener.proceed();
                }
            });
            this.node.getConnectionPool().connect(target, exchange, callback, timeout, timeUnit, exclusive);
        } else {
            callback.failed(exchange);
        }
    }

    boolean addRequest() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) != 0) {
                return false;
            }
            newState = oldState + 1;
            if ((newState & 0x3FFFFFFF) != 0x3FFFFFFF) continue;
            return false;
        } while (!stateUpdater.compareAndSet(this, oldState, newState));
        return true;
    }

    void requestDone() {
        int newState;
        int oldState;
        do {
            if (((oldState = this.state) & 0x3FFFFFFF) != 0) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, newState = oldState - 1));
    }

    public String toString() {
        return "Context{, path='" + this.path + '\'' + '}';
    }

    static enum Status {
        ENABLED,
        DISABLED,
        STOPPED;

    }
}

