/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.accesslog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributes;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.SubstituteEmptyWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicates;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ExchangeCompletionListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HandlerWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.accesslog.AccessLogReceiver;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.HandlerBuilder;

public class AccessLogHandler
implements HttpHandler {
    private final HttpHandler next;
    private final AccessLogReceiver accessLogReceiver;
    private final String formatString;
    private final ExchangeAttribute tokens;
    private final ExchangeCompletionListener exchangeCompletionListener = new AccessLogCompletionListener();
    private final Predicate predicate;

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, ClassLoader classLoader) {
        this(next, accessLogReceiver, formatString, classLoader, Predicates.truePredicate());
    }

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, ClassLoader classLoader, Predicate predicate) {
        this.next = next;
        this.accessLogReceiver = accessLogReceiver;
        this.predicate = predicate;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.tokens = ExchangeAttributes.parser(classLoader, new SubstituteEmptyWrapper("-")).parse(this.formatString);
    }

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, ExchangeAttribute attribute) {
        this(next, accessLogReceiver, formatString, attribute, Predicates.truePredicate());
    }

    public AccessLogHandler(HttpHandler next, AccessLogReceiver accessLogReceiver, String formatString, ExchangeAttribute attribute, Predicate predicate) {
        this.next = next;
        this.accessLogReceiver = accessLogReceiver;
        this.predicate = predicate;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.tokens = attribute;
    }

    private static String handleCommonNames(String formatString) {
        if (formatString.equals("common")) {
            return "%h %l %u %t \"%r\" %s %b";
        }
        if (formatString.equals("combined")) {
            return "%h %l %u %t \"%r\" %s %b \"%{i,Referer}\" \"%{i,User-Agent}\"";
        }
        if (formatString.equals("commonobf")) {
            return "%o %l %u %t \"%r\" %s %b";
        }
        if (formatString.equals("combinedobf")) {
            return "%o %l %u %t \"%r\" %s %b \"%{i,Referer}\" \"%{i,User-Agent}\"";
        }
        return formatString;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "AccessLogHandler{formatString='" + this.formatString + '\'' + '}';
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String format;
        private final String category;

        private Wrapper(String format, String category) {
            this.format = format;
            this.category = category;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            if (this.category == null || this.category.trim().isEmpty()) {
                return new AccessLogHandler(handler, (AccessLogReceiver)new JBossLoggingAccessLogReceiver(), this.format, Wrapper.class.getClassLoader());
            }
            return new AccessLogHandler(handler, (AccessLogReceiver)new JBossLoggingAccessLogReceiver(this.category), this.format, Wrapper.class.getClassLoader());
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "access-log";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("format", String.class);
            params.put("category", String.class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("format");
        }

        @Override
        public String defaultParameter() {
            return "format";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String)config.get("format"), (String)config.get("category"));
        }
    }

    private class AccessLogCompletionListener
    implements ExchangeCompletionListener {
        private AccessLogCompletionListener() {
        }

        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                if (AccessLogHandler.this.predicate == null || AccessLogHandler.this.predicate.resolve(exchange)) {
                    AccessLogHandler.this.accessLogReceiver.logMessage(AccessLogHandler.this.tokens.readAttribute(exchange));
                }
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

