/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ConduitWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.Connectors;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.ResponseCommitListener;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.protocol.http.HttpContinue;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.ConduitFactory;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSourceConduit;

public class HttpContinueReadHandler
implements HttpHandler {
    private static final ConduitWrapper<StreamSourceConduit> WRAPPER = new ConduitWrapper<StreamSourceConduit>(){

        @Override
        public StreamSourceConduit wrap(ConduitFactory<StreamSourceConduit> factory, HttpServerExchange exchange) {
            if (exchange.isRequestChannelAvailable() && !exchange.isResponseStarted()) {
                return new ContinueConduit(factory.create(), exchange);
            }
            return factory.create();
        }
    };
    private final HttpHandler handler;

    public HttpContinueReadHandler(HttpHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (HttpContinue.requiresContinueResponse(exchange)) {
            exchange.addRequestWrapper(WRAPPER);
            exchange.addResponseCommitListener(new ResponseCommitListener(){

                @Override
                public void beforeCommit(HttpServerExchange exchange) {
                    if (!HttpContinue.isContinueResponseSent(exchange)) {
                        exchange.setPersistent(false);
                        exchange.getConnection().terminateRequestChannel(exchange);
                    }
                }
            });
        }
        this.handler.handleRequest(exchange);
    }

    private static final class ContinueConduit
    extends AbstractStreamSourceConduit<StreamSourceConduit>
    implements StreamSourceConduit {
        private boolean sent = false;
        private HttpContinue.ContinueResponseSender response = null;
        private final HttpServerExchange exchange;

        protected ContinueConduit(StreamSourceConduit next, HttpServerExchange exchange) {
            super(next);
            this.exchange = exchange;
        }

        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            if (this.exchange.getStatusCode() == 417) {
                Connectors.terminateRequest(this.exchange);
                return -1L;
            }
            if (!this.sent) {
                this.sent = true;
                this.response = HttpContinue.createResponseSender(this.exchange);
            }
            if (this.response != null) {
                if (!this.response.send()) {
                    return 0L;
                }
                this.response = null;
            }
            return super.transferTo(position, count, target);
        }

        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            if (this.exchange.getStatusCode() == 417) {
                Connectors.terminateRequest(this.exchange);
                return -1L;
            }
            if (!this.sent) {
                this.sent = true;
                this.response = HttpContinue.createResponseSender(this.exchange);
            }
            if (this.response != null) {
                if (!this.response.send()) {
                    return 0L;
                }
                this.response = null;
            }
            return super.transferTo(count, throughBuffer, target);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.exchange.getStatusCode() == 417) {
                Connectors.terminateRequest(this.exchange);
                return -1;
            }
            if (!this.sent) {
                this.sent = true;
                this.response = HttpContinue.createResponseSender(this.exchange);
            }
            if (this.response != null) {
                if (!this.response.send()) {
                    return 0;
                }
                this.response = null;
            }
            return super.read(dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
            if (this.exchange.getStatusCode() == 417) {
                Connectors.terminateRequest(this.exchange);
                return -1L;
            }
            if (!this.sent) {
                this.sent = true;
                this.response = HttpContinue.createResponseSender(this.exchange);
            }
            if (this.response != null) {
                if (!this.response.send()) {
                    return 0L;
                }
                this.response = null;
            }
            return super.read(dsts, offs, len);
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
            long currentTime;
            if (this.exchange.getStatusCode() == 417) {
                return;
            }
            if (!this.sent) {
                this.sent = true;
                this.response = HttpContinue.createResponseSender(this.exchange);
            }
            long exitTime = System.currentTimeMillis() + timeUnit.toMillis(time);
            if (this.response != null) {
                while (!this.response.send()) {
                    currentTime = System.currentTimeMillis();
                    if (currentTime > exitTime) {
                        return;
                    }
                    this.response.awaitWritable(exitTime - currentTime, TimeUnit.MILLISECONDS);
                }
                this.response = null;
            }
            currentTime = System.currentTimeMillis();
            super.awaitReadable(exitTime - currentTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public void awaitReadable() throws IOException {
            if (this.exchange.getStatusCode() == 417) {
                return;
            }
            if (!this.sent) {
                this.sent = true;
                this.response = HttpContinue.createResponseSender(this.exchange);
            }
            if (this.response != null) {
                while (!this.response.send()) {
                    this.response.awaitWritable();
                }
                this.response = null;
            }
            super.awaitReadable();
        }
    }
}

