/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.AttachmentKey;

public class ExceptionHandler
implements HttpHandler {
    public static final AttachmentKey<Throwable> THROWABLE = AttachmentKey.create(Throwable.class);
    private final HttpHandler handler;
    private final List<ExceptionHandlerHolder<?>> exceptionHandlers = new CopyOnWriteArrayList();

    public ExceptionHandler(HttpHandler handler) {
        this.handler = handler;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            this.handler.handleRequest(exchange);
        }
        catch (Throwable throwable) {
            for (ExceptionHandlerHolder<?> holder : this.exceptionHandlers) {
                if (!holder.getClazz().isInstance(throwable)) continue;
                exchange.putAttachment(THROWABLE, throwable);
                holder.getHandler().handleRequest(exchange);
                return;
            }
            throw throwable;
        }
    }

    public <T extends Throwable> ExceptionHandler addExceptionHandler(Class<T> clazz, HttpHandler handler) {
        this.exceptionHandlers.add(new ExceptionHandlerHolder<T>(clazz, handler));
        return this;
    }

    private static class ExceptionHandlerHolder<T extends Throwable> {
        private final Class<T> clazz;
        private final HttpHandler handler;

        ExceptionHandlerHolder(Class<T> clazz, HttpHandler handler) {
            this.clazz = clazz;
            this.handler = handler;
        }

        public Class<T> getClazz() {
            return this.clazz;
        }

        public HttpHandler getHandler() {
            return this.handler;
        }
    }
}

