/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicates;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class PathSuffixPredicate
implements Predicate {
    private final String suffix;

    PathSuffixPredicate(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        return value.getRelativePath().endsWith(this.suffix);
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "path-suffix";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("path", String[].class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("path");
        }

        @Override
        public String defaultParameter() {
            return "path";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            String[] path = (String[])config.get("path");
            return Predicates.suffixes(path);
        }
    }
}

