/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Headers;

public class MaxContentSizePredicate
implements Predicate {
    private final long maxSize;

    MaxContentSizePredicate(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String length = value.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (length == null) {
            return false;
        }
        return Long.parseLong(length) > this.maxSize;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "max-content-size";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", Long.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            Long max = (Long)config.get("value");
            return new MaxContentSizePredicate(max);
        }
    }
}

