/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.Methods;

public class IdempotentPredicate
implements Predicate {
    public static final IdempotentPredicate INSTANCE = new IdempotentPredicate();
    private static final Set<HttpString> METHODS;

    @Override
    public boolean resolve(HttpServerExchange value) {
        return METHODS.contains(value.getRequestMethod());
    }

    static {
        HashSet<HttpString> methods = new HashSet<HttpString>();
        methods.add(Methods.GET);
        methods.add(Methods.DELETE);
        methods.add(Methods.PUT);
        methods.add(Methods.HEAD);
        methods.add(Methods.OPTIONS);
        METHODS = Collections.unmodifiableSet(methods);
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "idempotent";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            return INSTANCE;
        }
    }
}

