/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class EqualsPredicate
implements Predicate {
    private final ExchangeAttribute[] attributes;

    EqualsPredicate(ExchangeAttribute[] attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        if (this.attributes.length < 2) {
            return true;
        }
        String first = this.attributes[0].readAttribute(value);
        for (int i = 1; i < this.attributes.length; ++i) {
            String current = this.attributes[i].readAttribute(value);
            if (first == null) {
                if (current == null) continue;
                return false;
            }
            if (current == null) {
                return false;
            }
            if (first.equals(current)) continue;
            return false;
        }
        return true;
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "equals";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("value", ExchangeAttribute[].class);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            ExchangeAttribute[] value = (ExchangeAttribute[])config.get("value");
            return new EqualsPredicate(value);
        }
    }
}

