/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitReadableByteChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSourceConduit;

public class DebuggingStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private static final List<byte[]> data = new CopyOnWriteArrayList<byte[]>();

    public DebuggingStreamSourceConduit(StreamSourceConduit next) {
        super(next);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return target.transferFrom(new ConduitReadableByteChannel(this), position, count);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return IoUtils.transfer(new ConduitReadableByteChannel(this), count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int pos = dst.position();
        int res = super.read(dst);
        if (res > 0) {
            byte[] d = new byte[res];
            for (int i = 0; i < res; ++i) {
                d[i] = dst.get(i + pos);
            }
            data.add(d);
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        for (int i = offs; i < len; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.read(dsts[i]);
        }
        return 0L;
    }

    public static void dump() {
        for (int i = 0; i < data.size(); ++i) {
            System.out.println("Buffer " + i);
            StringBuilder sb = new StringBuilder();
            try {
                Buffers.dump(ByteBuffer.wrap(data.get(i)), (Appendable)sb, 0, 20);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.out.println(sb);
            System.out.println();
        }
    }
}

