/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.Buffers;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoUtils;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.channels.StreamSourceChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.AbstractStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitWritableByteChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.Conduits;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.StreamSinkConduit;

public class DebuggingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private static final List<byte[]> data = new CopyOnWriteArrayList<byte[]>();

    public DebuggingStreamSinkConduit(StreamSinkConduit next) {
        super(next);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int pos = src.position();
        int res = super.write(src);
        if (res > 0) {
            byte[] d = new byte[res];
            for (int i = 0; i < res; ++i) {
                d[i] = src.get(i + pos);
            }
            data.add(d);
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] dsts, int offs, int len) throws IOException {
        for (int i = offs; i < len; ++i) {
            if (!dsts[i].hasRemaining()) continue;
            return this.write(dsts[i]);
        }
        return 0L;
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return IoUtils.transfer(source, count, throughBuffer, new ConduitWritableByteChannel(this));
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return Conduits.writeFinalBasic(this, src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return Conduits.writeFinalBasic(this, srcs, offset, length);
    }

    public static void dump() {
        for (int i = 0; i < data.size(); ++i) {
            System.out.println("Write Buffer " + i);
            StringBuilder sb = new StringBuilder();
            try {
                Buffers.dump(ByteBuffer.wrap(data.get(i)), (Appendable)sb, 0, 20);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.out.println(sb);
            System.out.println();
        }
    }
}

