/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.client.http2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowOptions;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientProvider;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.ClientStatistics;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.client.http2.Http2ClientConnection;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.ByteActivityCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.BytesReceivedStreamSourceConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.conduits.BytesSentStreamSinkConduit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.connector.ByteBufferPool;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.protocols.http2.Http2Channel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ChannelListener;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.IoFuture;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.OptionMap;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.StreamConnection;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioIoThread;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.XnioWorker;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.conduits.ConduitStreamSinkChannel;
import net.thisptr.jmx.exporter.agent.shade.org.xnio.ssl.XnioSsl;

public class Http2PriorKnowledgeClientProvider
implements ClientProvider {
    private static final byte[] PRI_REQUEST = new byte[]{80, 82, 73, 32, 42, 32, 72, 84, 84, 80, 47, 50, 46, 48, 13, 10, 13, 10, 83, 77, 13, 10, 13, 10};

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, null, uri, worker, ssl, bufferPool, options);
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        this.connect(listener, null, uri, ioThread, ssl, bufferPool, options);
    }

    @Override
    public Set<String> handlesSchemes() {
        return new HashSet<String>(Arrays.asList("h2c-prior"));
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioWorker worker, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (bindAddress == null) {
            worker.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri.getHost()), options).addNotifier(this.createNotifier(listener), null);
        } else {
            worker.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri.getHost()), null, options).addNotifier(this.createNotifier(listener), null);
        }
    }

    @Override
    public void connect(ClientCallback<ClientConnection> listener, InetSocketAddress bindAddress, URI uri, XnioIoThread ioThread, XnioSsl ssl, ByteBufferPool bufferPool, OptionMap options) {
        if (bindAddress == null) {
            ioThread.openStreamConnection(new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri.getHost()), options).addNotifier(this.createNotifier(listener), null);
        } else {
            ioThread.openStreamConnection(bindAddress, new InetSocketAddress(uri.getHost(), uri.getPort() == -1 ? 80 : uri.getPort()), this.createOpenListener(listener, bufferPool, options, uri.getHost()), null, options).addNotifier(this.createNotifier(listener), null);
        }
    }

    private IoFuture.Notifier<StreamConnection, Object> createNotifier(final ClientCallback<ClientConnection> listener) {
        return new IoFuture.Notifier<StreamConnection, Object>(){

            @Override
            public void notify(IoFuture<? extends StreamConnection> ioFuture, Object o) {
                if (ioFuture.getStatus() == IoFuture.Status.FAILED) {
                    listener.failed(ioFuture.getException());
                }
            }
        };
    }

    private ChannelListener<StreamConnection> createOpenListener(final ClientCallback<ClientConnection> listener, final ByteBufferPool bufferPool, final OptionMap options, final String defaultHost) {
        return new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                Http2PriorKnowledgeClientProvider.this.handleConnected(connection, listener, bufferPool, options, defaultHost);
            }
        };
    }

    private void handleConnected(final StreamConnection connection, final ClientCallback<ClientConnection> listener, final ByteBufferPool bufferPool, final OptionMap options, final String defaultHost) {
        try {
            ClientStatisticsImpl clientStatistics;
            if (options.get(UndertowOptions.ENABLE_STATISTICS, false)) {
                clientStatistics = new ClientStatisticsImpl();
                connection.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(connection.getSinkChannel().getConduit(), new ByteActivityCallback(){

                    @Override
                    public void activity(long bytes) {
                        clientStatistics.written = clientStatistics.written + bytes;
                    }
                }));
                connection.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(connection.getSourceChannel().getConduit(), new ByteActivityCallback(){

                    @Override
                    public void activity(long bytes) {
                        clientStatistics.read = clientStatistics.read + bytes;
                    }
                }));
            } else {
                clientStatistics = null;
            }
            final ByteBuffer pri = ByteBuffer.wrap(PRI_REQUEST);
            pri.flip();
            ConduitStreamSinkChannel sink = connection.getSinkChannel();
            sink.write(pri);
            if (pri.hasRemaining()) {
                sink.setWriteListener((ChannelListener<? super ConduitStreamSinkChannel>)new ChannelListener<ConduitStreamSinkChannel>(){

                    @Override
                    public void handleEvent(ConduitStreamSinkChannel channel) {
                        try {
                            channel.write(pri);
                            if (pri.hasRemaining()) {
                                return;
                            }
                            listener.completed(new Http2ClientConnection(new Http2Channel(connection, null, bufferPool, null, true, false, options), false, defaultHost, clientStatistics, false));
                        }
                        catch (Throwable t) {
                            IOException e = t instanceof IOException ? (IOException)t : new IOException(t);
                            listener.failed(e);
                        }
                    }
                });
                return;
            }
            listener.completed(new Http2ClientConnection(new Http2Channel(connection, null, bufferPool, null, true, false, options), false, defaultHost, clientStatistics, false));
        }
        catch (Throwable t) {
            IOException e = t instanceof IOException ? (IOException)t : new IOException(t);
            listener.failed(e);
        }
    }

    private static class ClientStatisticsImpl
    implements ClientStatistics {
        private long requestCount;
        private long read;
        private long written;

        private ClientStatisticsImpl() {
        }

        @Override
        public long getRequests() {
            return this.requestCount;
        }

        @Override
        public long getRead() {
            return this.read;
        }

        @Override
        public long getWritten() {
            return this.written;
        }

        @Override
        public void reset() {
            this.read = 0L;
            this.written = 0L;
            this.requestCount = 0L;
        }
    }
}

