/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class ThreadNameAttribute
implements ExchangeAttribute {
    public static final String THREAD_NAME_SHORT = "%I";
    public static final String THREAD_NAME = "%{THREAD_NAME}";
    public static final ExchangeAttribute INSTANCE = new ThreadNameAttribute();

    private ThreadNameAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        return Thread.currentThread().getName();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Thread name", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Thread name";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(ThreadNameAttribute.THREAD_NAME) || token.equals(ThreadNameAttribute.THREAD_NAME_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

