/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HeaderValues;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;

public class RequestHeaderAttribute
implements ExchangeAttribute {
    private final HttpString requestHeader;

    public RequestHeaderAttribute(HttpString requestHeader) {
        this.requestHeader = requestHeader;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        HeaderValues header = exchange.getRequestHeaders().get(this.requestHeader);
        if (header == null) {
            return null;
        }
        if (header.size() == 1) {
            return header.getFirst();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < header.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(header.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.getRequestHeaders().put(this.requestHeader, newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request header";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{i,") && token.endsWith("}")) {
                HttpString headerName = HttpString.tryFromString(token.substring(4, token.length() - 1));
                return new RequestHeaderAttribute(headerName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

