/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.Cookie;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.CookieImpl;

public class RequestCookieAttribute
implements ExchangeAttribute {
    private static final String TOKEN_PREFIX = "%{req-cookie,";
    private final String cookieName;

    public RequestCookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Cookie cookie = exchange.getRequestCookies().get(this.cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.getRequestCookies().put(this.cookieName, new CookieImpl(this.cookieName, newValue));
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Request cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith(RequestCookieAttribute.TOKEN_PREFIX) && token.endsWith("}")) {
                String cookieName = token.substring(RequestCookieAttribute.TOKEN_PREFIX.length(), token.length() - 1);
                return new RequestCookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

