/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.net.InetSocketAddress;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class RemoteHostAttribute
implements ExchangeAttribute {
    public static final String REMOTE_HOST_NAME_SHORT = "%h";
    public static final String REMOTE_HOST = "%{REMOTE_HOST}";
    public static final ExchangeAttribute INSTANCE = new RemoteHostAttribute();

    private RemoteHostAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        InetSocketAddress sourceAddress = exchange.getSourceAddress();
        return sourceAddress.getHostString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Remote host", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Remote host";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(RemoteHostAttribute.REMOTE_HOST) || token.equals(RemoteHostAttribute.REMOTE_HOST_NAME_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

