/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class QuotingExchangeAttribute
implements ExchangeAttribute {
    private final ExchangeAttribute exchangeAttribute;
    public static final ExchangeAttributeWrapper WRAPPER = new Wrapper();

    public QuotingExchangeAttribute(ExchangeAttribute exchangeAttribute) {
        this.exchangeAttribute = exchangeAttribute;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        String svalue = this.exchangeAttribute.readAttribute(exchange);
        if (svalue == null || "-".equals(svalue) || svalue.isEmpty()) {
            return "-";
        }
        StringBuilder buffer = new StringBuilder(svalue.length() + 2);
        buffer.append('\'');
        int i = 0;
        while (i < svalue.length()) {
            int j = svalue.indexOf(39, i);
            if (j == -1) {
                buffer.append(svalue.substring(i));
                i = svalue.length();
                continue;
            }
            buffer.append(svalue.substring(i, j + 1));
            buffer.append('\"');
            i = j + 2;
        }
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException();
    }

    public static class Wrapper
    implements ExchangeAttributeWrapper {
        @Override
        public ExchangeAttribute wrap(ExchangeAttribute attribute) {
            return new QuotingExchangeAttribute(attribute);
        }
    }
}

