/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.util.ArrayDeque;
import java.util.Deque;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class QueryParameterAttribute
implements ExchangeAttribute {
    private final String parameter;

    public QueryParameterAttribute(String parameter) {
        this.parameter = parameter;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Deque<String> res = exchange.getQueryParameters().get(this.parameter);
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return "";
        }
        if (res.size() == 1) {
            return res.getFirst();
        }
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        for (String s2 : res) {
            sb.append(s2);
            if (++i == res.size()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        ArrayDeque<String> value = new ArrayDeque<String>();
        value.add(newValue);
        exchange.getQueryParameters().put(this.parameter, value);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Query Parameter";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{q,") && token.endsWith("}")) {
                String qp = token.substring(4, token.length() - 1);
                return new QueryParameterAttribute(qp);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

