/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.util.Map;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class PredicateContextAttribute
implements ExchangeAttribute {
    private final String name;

    public PredicateContextAttribute(String name) {
        this.name = name;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Map<String, Object> context = exchange.getAttachment(Predicate.PREDICATE_CONTEXT);
        if (context != null) {
            Object object = context.get(this.name);
            return object == null ? null : object.toString();
        }
        return null;
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        Map<String, Object> context = exchange.getAttachment(Predicate.PREDICATE_CONTEXT);
        if (context != null) {
            context.put(this.name, newValue);
        }
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Predicate context variable";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("${") && token.endsWith("}") && token.length() > 3) {
                return new PredicateContextAttribute(token.substring(2, token.length() - 1));
            }
            if (token.startsWith("$")) {
                return new PredicateContextAttribute(token.substring(1, token.length()));
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

