/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.net.InetSocketAddress;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class LocalIPAttribute
implements ExchangeAttribute {
    public static final String LOCAL_IP = "%{LOCAL_IP}";
    public static final String LOCAL_IP_SHORT = "%A";
    public static final ExchangeAttribute INSTANCE = new LocalIPAttribute();

    private LocalIPAttribute() {
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        InetSocketAddress localAddress = (InetSocketAddress)exchange.getConnection().getLocalAddress();
        return localAddress.getAddress().getHostAddress();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Local IP", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Local IP";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(LocalIPAttribute.LOCAL_IP) || token.equals(LocalIPAttribute.LOCAL_IP_SHORT)) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

