/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import java.util.Arrays;
import java.util.Collections;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.AuthenticationTypeExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.BytesSentAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ConstantExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.CookieAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.DateTimeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeWrapper;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.LocalIPAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.LocalPortAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.LocalServerNameAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.QueryStringAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RelativePathAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RemoteIPAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RemoteObfuscatedIPAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RemoteUserAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RequestHeaderAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RequestLineAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RequestMethodAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RequestProtocolAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.RequestURLAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ResponseCodeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ResponseHeaderAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ResponseReasonPhraseAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ThreadNameAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.TransportProtocolAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.util.HttpString;

public class ExchangeAttributes {
    public static ExchangeAttributeParser parser(ClassLoader classLoader) {
        return new ExchangeAttributeParser(classLoader, Collections.emptyList());
    }

    public static ExchangeAttributeParser parser(ClassLoader classLoader, ExchangeAttributeWrapper ... wrappers) {
        return new ExchangeAttributeParser(classLoader, Arrays.asList(wrappers));
    }

    public static ExchangeAttribute cookie(String cookieName) {
        return new CookieAttribute(cookieName);
    }

    public static ExchangeAttribute bytesSent(boolean dashIfZero) {
        return new BytesSentAttribute(dashIfZero);
    }

    public static ExchangeAttribute dateTime() {
        return DateTimeAttribute.INSTANCE;
    }

    public static ExchangeAttribute localIp() {
        return LocalIPAttribute.INSTANCE;
    }

    public static ExchangeAttribute localPort() {
        return LocalPortAttribute.INSTANCE;
    }

    public static ExchangeAttribute localServerName() {
        return LocalServerNameAttribute.INSTANCE;
    }

    public static ExchangeAttribute queryString() {
        return QueryStringAttribute.INSTANCE;
    }

    public static ExchangeAttribute relativePath() {
        return RelativePathAttribute.INSTANCE;
    }

    public static ExchangeAttribute remoteIp() {
        return RemoteIPAttribute.INSTANCE;
    }

    public static ExchangeAttribute remoteObfuscatedIp() {
        return RemoteObfuscatedIPAttribute.INSTANCE;
    }

    public static ExchangeAttribute remoteUser() {
        return RemoteUserAttribute.INSTANCE;
    }

    public static ExchangeAttribute requestHeader(HttpString header) {
        return new RequestHeaderAttribute(header);
    }

    public static ExchangeAttribute requestList() {
        return RequestLineAttribute.INSTANCE;
    }

    public static ExchangeAttribute requestMethod() {
        return RequestMethodAttribute.INSTANCE;
    }

    public static ExchangeAttribute requestProtocol() {
        return RequestProtocolAttribute.INSTANCE;
    }

    public static ExchangeAttribute requestURL() {
        return RequestURLAttribute.INSTANCE;
    }

    public static ExchangeAttribute responseCode() {
        return ResponseCodeAttribute.INSTANCE;
    }

    public static ExchangeAttribute responseReasonPhrase() {
        return ResponseReasonPhraseAttribute.INSTANCE;
    }

    public static ExchangeAttribute responseHeader(HttpString header) {
        return new ResponseHeaderAttribute(header);
    }

    public static ExchangeAttribute transportProtocol() {
        return TransportProtocolAttribute.INSTANCE;
    }

    public static ExchangeAttribute threadName() {
        return ThreadNameAttribute.INSTANCE;
    }

    public static ExchangeAttribute constant(String value) {
        return new ConstantExchangeAttribute(value);
    }

    public static String resolve(HttpServerExchange exchange, ExchangeAttribute[] attributes) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < attributes.length; ++i) {
            String str = attributes[i].readAttribute(exchange);
            if (str == null) continue;
            result.append(str);
        }
        return result.toString();
    }

    private ExchangeAttributes() {
    }

    public static ExchangeAttribute authenticationType() {
        return AuthenticationTypeExchangeAttribute.INSTANCE;
    }
}

