/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute;

import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttributeBuilder;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ReadOnlyAttributeException;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpServerExchange;

public class BytesSentAttribute
implements ExchangeAttribute {
    public static final String BYTES_SENT_SHORT_UPPER = "%B";
    public static final String BYTES_SENT_SHORT_LOWER = "%b";
    public static final String BYTES_SENT = "%{BYTES_SENT}";
    private final boolean dashIfZero;

    public BytesSentAttribute(boolean dashIfZero) {
        this.dashIfZero = dashIfZero;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        if (this.dashIfZero) {
            long bytesSent = exchange.getResponseBytesSent();
            return bytesSent == 0L ? "-" : Long.toString(bytesSent);
        }
        return Long.toString(exchange.getResponseBytesSent());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Bytes sent", newValue);
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Bytes Sent";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(BytesSentAttribute.BYTES_SENT_SHORT_LOWER)) {
                return new BytesSentAttribute(true);
            }
            if (token.equals(BytesSentAttribute.BYTES_SENT) || token.equals(BytesSentAttribute.BYTES_SENT_SHORT_UPPER)) {
                return new BytesSentAttribute(false);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

