/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jmx.exporter.agent.shade.io.undertow;

import java.util.List;
import java.util.concurrent.TimeUnit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.UndertowMessages;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.attribute.ExchangeAttribute;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.Predicate;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicateParser;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.predicate.PredicatesHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.HttpHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.JvmRouteHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.RoutingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.AccessControlListHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.DateHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.DisableCacheHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ExceptionHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.GracefulShutdownHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.HttpContinueAcceptingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.HttpContinueReadHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.HttpTraceHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.IPAddressAccessControlHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.LearningPushHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.NameVirtualHostHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.PathHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.PathTemplateHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.PredicateContextHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.PredicateHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ProxyPeerAddressHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.RedirectHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.RequestDumpingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.RequestLimit;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.RequestLimitingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.ResponseRateLimitingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.SetAttributeHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.SetHeaderHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.URLDecodingHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.builder.PredicatedHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyClient;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.proxy.ProxyHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.ResourceHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.resource.ResourceManager;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.server.handlers.sse.ServerSentEventHandler;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.WebSocketConnectionCallback;
import net.thisptr.jmx.exporter.agent.shade.io.undertow.websockets.WebSocketProtocolHandshakeHandler;

public class Handlers {
    public static PathHandler path(HttpHandler defaultHandler) {
        return new PathHandler(defaultHandler);
    }

    public static PathHandler path() {
        return new PathHandler();
    }

    public static PathTemplateHandler pathTemplate() {
        return new PathTemplateHandler();
    }

    public static RoutingHandler routing(boolean rewriteQueryParams) {
        return new RoutingHandler(rewriteQueryParams);
    }

    public static RoutingHandler routing() {
        return new RoutingHandler();
    }

    public static PathTemplateHandler pathTemplate(boolean rewriteQueryParams) {
        return new PathTemplateHandler(rewriteQueryParams);
    }

    public static NameVirtualHostHandler virtualHost() {
        return new NameVirtualHostHandler();
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler) {
        return new NameVirtualHostHandler().setDefaultHandler(defaultHandler);
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler hostHandler, String ... hostnames) {
        NameVirtualHostHandler handler = new NameVirtualHostHandler();
        for (String host : hostnames) {
            handler.addHost(host, hostHandler);
        }
        return handler;
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler, HttpHandler hostHandler, String ... hostnames) {
        return Handlers.virtualHost(hostHandler, hostnames).setDefaultHandler(defaultHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketConnectionCallback sessionHandler) {
        return new WebSocketProtocolHandshakeHandler(sessionHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketConnectionCallback sessionHandler, HttpHandler next) {
        return new WebSocketProtocolHandshakeHandler(sessionHandler, next);
    }

    public static ServerSentEventHandler serverSentEvents(ServerSentEventConnectionCallback callback) {
        return new ServerSentEventHandler(callback);
    }

    public static ServerSentEventHandler serverSentEvents() {
        return new ServerSentEventHandler();
    }

    public static ResourceHandler resource(ResourceManager resourceManager) {
        return new ResourceHandler(resourceManager).setDirectoryListingEnabled(false);
    }

    public static RedirectHandler redirect(String location) {
        return new RedirectHandler(location);
    }

    public static HttpTraceHandler trace(HttpHandler next) {
        return new HttpTraceHandler(next);
    }

    @Deprecated
    public static DateHandler date(HttpHandler next) {
        return new DateHandler(next);
    }

    public static PredicateHandler predicate(Predicate predicate, HttpHandler trueHandler, HttpHandler falseHandler) {
        return new PredicateHandler(predicate, trueHandler, falseHandler);
    }

    public static HttpHandler predicateContext(HttpHandler next) {
        return new PredicateContextHandler(next);
    }

    public static PredicatesHandler predicates(List<PredicatedHandler> handlers, HttpHandler next) {
        PredicatesHandler predicatesHandler = new PredicatesHandler(next);
        for (PredicatedHandler handler : handlers) {
            predicatesHandler.addPredicatedHandler(handler);
        }
        return predicatesHandler;
    }

    public static SetHeaderHandler header(HttpHandler next, String headerName, String headerValue) {
        return new SetHeaderHandler(next, headerName, headerValue);
    }

    public static SetHeaderHandler header(HttpHandler next, String headerName, ExchangeAttribute headerValue) {
        return new SetHeaderHandler(next, headerName, headerValue);
    }

    public static final IPAddressAccessControlHandler ipAccessControl(HttpHandler next, boolean defaultAllow) {
        return new IPAddressAccessControlHandler(next).setDefaultAllow(defaultAllow);
    }

    public static final AccessControlListHandler acl(HttpHandler next, boolean defaultAllow, ExchangeAttribute attribute) {
        return new AccessControlListHandler(next, attribute).setDefaultAllow(defaultAllow);
    }

    public static final HttpContinueReadHandler httpContinueRead(HttpHandler next) {
        return new HttpContinueReadHandler(next);
    }

    public static final HttpContinueAcceptingHandler httpContinueAccepting(HttpHandler next, Predicate accept) {
        return new HttpContinueAcceptingHandler(next, accept);
    }

    public static final HttpContinueAcceptingHandler httpContinueAccepting(HttpHandler next) {
        return new HttpContinueAcceptingHandler(next);
    }

    public static final URLDecodingHandler urlDecoding(HttpHandler next, String charset) {
        return new URLDecodingHandler(next, charset);
    }

    public static SetAttributeHandler setAttribute(HttpHandler next, String attribute, String value, ClassLoader classLoader) {
        return new SetAttributeHandler(next, attribute, value, classLoader);
    }

    public static HttpHandler rewrite(String condition, String target, ClassLoader classLoader, HttpHandler next) {
        return Handlers.predicateContext(Handlers.predicate(PredicateParser.parse(condition, classLoader), Handlers.setAttribute(next, "%R", target, classLoader), next));
    }

    public static HttpHandler urlDecodingHandler(String charset, HttpHandler next) {
        return new URLDecodingHandler(next, charset);
    }

    public static GracefulShutdownHandler gracefulShutdown(HttpHandler next) {
        return new GracefulShutdownHandler(next);
    }

    public static ProxyPeerAddressHandler proxyPeerAddress(HttpHandler next) {
        return new ProxyPeerAddressHandler(next);
    }

    public static JvmRouteHandler jvmRoute(String sessionCookieName, String jvmRoute, HttpHandler next) {
        return new JvmRouteHandler(next, sessionCookieName, jvmRoute);
    }

    public static RequestLimitingHandler requestLimitingHandler(int maxRequest, int queueSize, HttpHandler next) {
        return new RequestLimitingHandler(maxRequest, queueSize, next);
    }

    public static RequestLimitingHandler requestLimitingHandler(RequestLimit requestLimit, HttpHandler next) {
        return new RequestLimitingHandler(requestLimit, next);
    }

    public static ProxyHandler proxyHandler(ProxyClient proxyClient, int maxRequestTime, HttpHandler next) {
        return ProxyHandler.builder().setProxyClient(proxyClient).setNext(next).setMaxRequestTime(maxRequestTime).build();
    }

    public static ProxyHandler proxyHandler(ProxyClient proxyClient, HttpHandler next) {
        return ProxyHandler.builder().setProxyClient(proxyClient).setNext(next).build();
    }

    public static ProxyHandler proxyHandler(ProxyClient proxyClient) {
        return ProxyHandler.builder().setProxyClient(proxyClient).build();
    }

    public static HttpHandler disableCache(HttpHandler next) {
        return new DisableCacheHandler(next);
    }

    public static HttpHandler requestDump(HttpHandler next) {
        return new RequestDumpingHandler(next);
    }

    public static ExceptionHandler exceptionHandler(HttpHandler next) {
        return new ExceptionHandler(next);
    }

    public static ResponseRateLimitingHandler responseRateLimitingHandler(HttpHandler next, int bytes, long time, TimeUnit timeUnit) {
        return new ResponseRateLimitingHandler(next, bytes, time, timeUnit);
    }

    public static LearningPushHandler learningPushHandler(int maxEntries, int maxAge, HttpHandler next) {
        return new LearningPushHandler(maxEntries, maxAge, next);
    }

    public static LearningPushHandler learningPushHandler(int maxEntries, HttpHandler next) {
        return new LearningPushHandler(maxEntries, -1, next);
    }

    private Handlers() {
    }

    public static void handlerNotNull(HttpHandler handler) {
        if (handler == null) {
            throw UndertowMessages.MESSAGES.handlerCannotBeNull();
        }
    }
}

